/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.internal;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;

public enum PluginScanner {
    INSTANCE;

    private final Map<String, Class<?>> pluginClassMap = new ConcurrentHashMap();
    private final Map<Class<? extends Annotation>, List<Class<?>>> annotatedClassesMap = new ConcurrentHashMap();

    @Deprecated
    public void scanJar(@NotNull File file) {
        try {
            this.scanJar(new JarFile(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void scanJar(@NotNull JarFile jarFile) {
        this.pluginClassMap.clear();
        Enumeration<JarEntry> entries = jarFile.entries();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        while (entries.hasMoreElements()) {
            try {
                JarEntry entry = entries.nextElement();
                boolean isClassFile = entry.getName().endsWith(".class");
                if (!isClassFile) continue;
                String className = entry.getName().replace('/', '.').substring(0, entry.getName().length() - 6);
                Class<?> clazz = classLoader.loadClass(className);
                this.pluginClassMap.put(className, clazz);
                for (Annotation annotation : clazz.getAnnotations()) {
                    List<Object> annotatedClasses;
                    Class<? extends Annotation> annotationClass = annotation.annotationType();
                    if (this.annotatedClassesMap.containsKey(annotationClass)) {
                        annotatedClasses = this.annotatedClassesMap.get(annotationClass);
                        if (annotatedClasses.contains(clazz)) continue;
                        annotatedClasses.add(clazz);
                        continue;
                    }
                    annotatedClasses = new ArrayList();
                    annotatedClasses.add(clazz);
                    this.annotatedClassesMap.put(annotationClass, annotatedClasses);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError entry) {
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        try {
            jarFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <T> List<Class<T>> getSubClasses(Class<T> clazz) {
        ArrayList subClasses = new ArrayList();
        this.pluginClassMap.forEach((name, cachedClass) -> {
            if (clazz.isAssignableFrom((Class<?>)cachedClass)) {
                subClasses.add(clazz);
            }
        });
        return subClasses;
    }

    @NotNull
    public List<Class<?>> getAnnotatedClasses(@NotNull Class<? extends Annotation> annotationClass) {
        return this.annotatedClassesMap.containsKey(annotationClass) ? this.annotatedClassesMap.get(annotationClass) : new ArrayList();
    }
}

