/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.lang;

import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.LangManager;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.entry.LangEntry;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.LocaleHelper;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ReflectionHelper;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LangEntryContainer {
    private final Class<?> containerClass;
    private final Map<String, BukkitConfigWrapper> langConfigWrapperMap;
    private final String langFileFolder;
    private final Plugin plugin;
    private final String defLang;

    public LangEntryContainer(@NotNull Plugin plugin, @NotNull Class<?> containerClass, String langFileFolder, String defLang) {
        this.plugin = plugin;
        this.langConfigWrapperMap = new ConcurrentHashMap<String, BukkitConfigWrapper>();
        this.langFileFolder = langFileFolder;
        this.containerClass = containerClass;
        this.defLang = defLang;
        this.saveDefLangFiles();
    }

    private void saveDefLangFiles() {
        for (Locale locale : Locale.getAvailableLocales()) {
            File file;
            String lang = LocaleHelper.localToLang(locale);
            String langFileName = this.langFileFolder + "/" + lang + ".yml";
            if (this.plugin.getResource(langFileName) == null || (file = new File(this.plugin.getDataFolder(), langFileName)).exists()) continue;
            this.plugin.saveResource(langFileName, false);
        }
    }

    public Class<?> containerClass() {
        return this.containerClass;
    }

    public Map<String, BukkitConfigWrapper> langConfigWrapperMap() {
        return this.langConfigWrapperMap;
    }

    public String langFileFolder() {
        return this.langFileFolder;
    }

    public void reload() {
        this.loadLangFiles();
        this.langConfigWrapperMap.forEach((lang, configWrapper) -> configWrapper.reloadConfig());
        for (Field field : this.containerClass.getDeclaredFields()) {
            Object object;
            if (!Modifier.isStatic(field.getModifiers()) || !((object = ReflectionHelper.getDeclaredFieldObj(field, null)) instanceof LangEntry)) continue;
            LangEntry langEntry = (LangEntry)object;
            if (!langEntry.defLang().equals(this.defLang)) {
                langEntry.setDefLang(this.defLang);
            }
            langEntry.load(this);
            LangManager.INSTANCE.putLangEntry(this.langFileFolder, langEntry);
        }
    }

    protected void loadLangFiles() {
        this.langConfigWrapperMap.clear();
        File folder = new File(this.plugin.getDataFolder(), this.langFileFolder);
        List<File> yamlFiles = IOHelper.allYamlFiles(folder);
        if (yamlFiles.isEmpty()) {
            this.saveDefLangFiles();
            yamlFiles = IOHelper.allYamlFiles(folder);
        }
        for (File langFile : yamlFiles) {
            String fileName = langFile.getName();
            String lang = fileName.substring(0, fileName.lastIndexOf("."));
            BukkitConfigWrapper configWrapper = new BukkitConfigWrapper(langFile);
            configWrapper.reloadConfig();
            this.langConfigWrapperMap.put(lang, configWrapper);
        }
        this.updateLangFiles();
    }

    private void updateLangFiles() {
        this.langConfigWrapperMap.forEach((lang, configWrapper) -> {
            YamlConfiguration defLangConfig = this.getDefLangConfig((String)lang);
            if (defLangConfig == null) {
                return;
            }
            for (String key : defLangConfig.getKeys(true)) {
                if (configWrapper.contains(key)) continue;
                configWrapper.set(key, defLangConfig.get(key));
            }
            configWrapper.saveConfig();
        });
    }

    public boolean containsLang(String lang) {
        return this.langConfigWrapperMap.containsKey(lang);
    }

    @Nullable
    public BukkitConfigWrapper getLangConfigWrapper(String lang) {
        return this.langConfigWrapperMap.get(lang);
    }

    @NotNull
    public BukkitConfigWrapper createNewLang(String lang) {
        String fileName = lang + ".yml";
        BukkitConfigWrapper langConfigWrapper = new BukkitConfigWrapper(this.plugin, this.langFileFolder + "/" + fileName);
        this.langConfigWrapperMap.put(lang, langConfigWrapper);
        return langConfigWrapper;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public YamlConfiguration getDefLangConfig(String lang) {
        String langFileName = this.langFileFolder + "/" + lang + ".yml";
        try (InputStream langFileInputStream = this.plugin.getResource(langFileName);){
            if (langFileInputStream == null) {
                YamlConfiguration yamlConfiguration2 = null;
                return yamlConfiguration2;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(langFileInputStream, Charsets.UTF_8));
            return yamlConfiguration;
        }
        catch (IOException e) {
            return null;
        }
    }
}

