/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.lang;

import com.github.yufiriamazenta.craftorithm.crypticlib.internal.PluginScanner;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.LangEntryContainer;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.LangHandler;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.entry.LangEntry;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.entry.StringLangEntry;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ENABLE, priority=-2147483648), @TaskRule(lifeCycle=LifeCycle.RELOAD), @TaskRule(lifeCycle=LifeCycle.DISABLE)})
public enum LangManager implements BukkitLifeCycleTask
{
    INSTANCE;

    private final Map<String, Map<String, LangEntry<?>>> folderLangEntryMap = new ConcurrentHashMap();
    private final Map<String, LangEntryContainer> langEntryContainerMap = new ConcurrentHashMap<String, LangEntryContainer>();
    private final Pattern langReplacePattern = Pattern.compile("<translate:([^>]+)>");

    public void removeLangEntryContainer(@NotNull String langFileFolder) {
        LangEntryContainer container = this.langEntryContainerMap.remove(langFileFolder);
        if (container == null) {
            return;
        }
        this.folderLangEntryMap.remove(container.langFileFolder());
    }

    @Nullable
    public LangEntry<?> getLangEntry(@NotNull String langFileFolder, @NotNull String key) {
        Map<String, LangEntry<?>> langEntryMap = this.folderLangEntryMap.get(langFileFolder);
        if (langEntryMap == null) {
            return null;
        }
        return langEntryMap.get(key);
    }

    public void putLangEntry(@NotNull String langFileFolder, @NotNull LangEntry<?> entry) {
        Map<Object, Object> langEntryMap;
        if (this.folderLangEntryMap.containsKey(langFileFolder)) {
            langEntryMap = this.folderLangEntryMap.get(langFileFolder);
        } else {
            langEntryMap = new ConcurrentHashMap();
            this.folderLangEntryMap.put(langFileFolder, langEntryMap);
        }
        langEntryMap.put(entry.key(), entry);
    }

    public String replaceLang(String originStr, CommandSender sender) {
        if (originStr == null) {
            return null;
        }
        Matcher matcher = this.langReplacePattern.matcher(originStr);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            result.append(originStr, lastEnd, matcher.start());
            String langKey = matcher.group(1);
            String[] split = langKey.split(":");
            if (split.length < 2) {
                result.append(langKey);
            } else {
                LangEntry<?> langEntry = this.getLangEntry(split[0], String.join((CharSequence)":", Arrays.copyOfRange(split, 1, split.length)));
                if (!(langEntry instanceof StringLangEntry)) {
                    result.append(langKey);
                } else {
                    StringLangEntry stringLangEntry = (StringLangEntry)langEntry;
                    String replacement = sender instanceof Player ? (String)stringLangEntry.value((Player)sender) : (String)stringLangEntry.value();
                    result.append(replacement);
                }
            }
            lastEnd = matcher.end();
        }
        result.append(originStr.substring(lastEnd));
        return result.toString();
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        switch (lifeCycle) {
            case ENABLE: {
                PluginScanner.INSTANCE.getAnnotatedClasses(LangHandler.class).forEach(langClass -> {
                    LangHandler langHandler = langClass.getAnnotation(LangHandler.class);
                    String langFileFolder = langHandler.langFileFolder();
                    String defLang = langHandler.defLang();
                    LangEntryContainer container = new LangEntryContainer(plugin, (Class<?>)langClass, langFileFolder, defLang);
                    this.langEntryContainerMap.put(langFileFolder, container);
                    container.reload();
                });
                break;
            }
            case RELOAD: {
                this.folderLangEntryMap.clear();
                this.langEntryContainerMap.forEach((langFolder, container) -> container.reload());
                break;
            }
            case DISABLE: {
                this.langEntryContainerMap.clear();
                this.folderLangEntryMap.clear();
            }
        }
    }
}

