/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.lang.entry;

import com.github.yufiriamazenta.craftorithm.crypticlib.lang.LangEntryContainer;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.LocaleHelper;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class LangEntry<T> {
    protected final Map<String, T> langMap;
    protected final String key;
    protected T defValue;
    protected String defLang = "en_us";

    public LangEntry(@NotNull String key, T defValue) {
        this.key = key;
        this.defValue = defValue;
        this.langMap = new ConcurrentHashMap<String, T>();
    }

    public LangEntry<T> setValue(@NotNull Locale locale, @NotNull T value) {
        return this.setValue(LocaleHelper.localToLang(locale), value);
    }

    public LangEntry<T> setValue(@NotNull String lang, @NotNull T value) {
        this.langMap.put(lang.toLowerCase(), value);
        return this;
    }

    public T value(@NotNull Player player) {
        return this.value(player.getLocale());
    }

    public T value(@NotNull Locale locale) {
        return this.value(LocaleHelper.localToLang(locale));
    }

    public T value(@NotNull String lang) {
        if (this.langMap.containsKey(lang = lang.toLowerCase())) {
            return this.langMap.get(lang);
        }
        if (this.langMap.containsKey(this.defLang)) {
            return this.langMap.get(this.defLang);
        }
        return this.defValue;
    }

    public T value() {
        return this.value(Locale.getDefault());
    }

    public String key() {
        return this.key;
    }

    public T def() {
        return this.defValue;
    }

    public abstract LangEntry<T> load(LangEntryContainer var1);

    public String defLang() {
        return this.defLang;
    }

    public LangEntry<T> setDefLang(String defLang) {
        this.defLang = defLang;
        return this;
    }

    public void send(CommandSender sender) {
        this.send(sender, Collections.emptyMap());
    }

    public abstract void send(CommandSender var1, Map<String, String> var2);
}

