/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.platform;

import com.github.yufiriamazenta.craftorithm.crypticlib.platform.IPlatform;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.BukkitScheduler;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.IScheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public enum BukkitPlatform implements IPlatform
{
    INSTANCE;


    @Override
    @NotNull
    public IPlatform.PlatformType type() {
        return IPlatform.PlatformType.BUKKIT;
    }

    @Override
    @NotNull
    public IScheduler scheduler() {
        return BukkitScheduler.INSTANCE;
    }

    @Override
    public Future<Boolean> teleportEntity(@NotNull Entity entity, @NotNull Location location, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerTeleportEvent.TeleportCause cause) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        future.complete(entity.teleport(location, cause));
        return future;
    }

    @Override
    public Future<Boolean> teleportEntity(@NotNull Entity entity, @NotNull Location location) {
        return this.teleportEntity(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean isBukkit() {
        return true;
    }

    @Override
    public boolean isPaper() {
        return false;
    }

    @Override
    public boolean isFolia() {
        return false;
    }
}

