/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.resource;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLib;
import com.github.yufiriamazenta.craftorithm.crypticlib.internal.PluginScanner;
import com.github.yufiriamazenta.craftorithm.crypticlib.resource.NetworkResource;
import com.github.yufiriamazenta.craftorithm.crypticlib.resource.NetworkResources;
import com.github.yufiriamazenta.craftorithm.crypticlib.resource.ResourceLoadException;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.FunctionExecutor;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ResourceLoader {
    private static List<NetworkResource> loadResources() {
        ArrayList<NetworkResource> resources = new ArrayList<NetworkResource>();
        PluginScanner.INSTANCE.getAnnotatedClasses(NetworkResources.class).forEach(resourcesClass -> {
            NetworkResources networkResources = resourcesClass.getAnnotation(NetworkResources.class);
            resources.addAll(Arrays.asList(networkResources.resources()));
        });
        PluginScanner.INSTANCE.getAnnotatedClasses(NetworkResource.class).forEach(resourceClass -> {
            NetworkResource networkResource = resourceClass.getAnnotation(NetworkResource.class);
            resources.add(networkResource);
        });
        return resources;
    }

    public static void downloadResources(File pluginDataFolder) {
        List<NetworkResource> networkResources = ResourceLoader.loadResources();
        if (networkResources.isEmpty()) {
            return;
        }
        IOHelper.info("Resources downloaded in " + FunctionExecutor.execute(() -> {
            IOHelper.info("Downloading resources...");
            networkResources.forEach(resource -> {
                File out = new File(pluginDataFolder, resource.filePath());
                if (out.exists() && !resource.downloadIfExist()) {
                    return;
                }
                String[] downloadUrl = resource.downloadUrl();
                boolean success = false;
                for (String url : downloadUrl) {
                    try {
                        IOHelper.downloadFile(new URL(url), out);
                        success = true;
                        break;
                    }
                    catch (IOException e) {
                        IOHelper.debug("&cFailed to download file from url " + url);
                        if (!CrypticLib.debug()) continue;
                        e.printStackTrace();
                    }
                }
                if (!success) {
                    if (resource.throwIfFailed()) {
                        throw new ResourceLoadException(resource.filePath());
                    }
                    IOHelper.info("&cDownload resource" + resource.filePath() + "failed.");
                } else {
                    IOHelper.info("Download resource " + resource.filePath() + " success.");
                }
            });
        }) + " ms.");
    }
}

