/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.scheduler;

import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.IScheduler;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.task.FoliaTaskWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.task.ITaskWrapper;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.INIT)})
public enum FoliaScheduler implements IScheduler,
BukkitLifeCycleTask
{
    INSTANCE;

    private Plugin plugin;

    @Override
    public ITaskWrapper sync(@NotNull Runnable task) {
        return new FoliaTaskWrapper(Bukkit.getGlobalRegionScheduler().run(this.plugin, this.runnableToConsumer(task)));
    }

    @Override
    public ITaskWrapper async(@NotNull Runnable task) {
        return new FoliaTaskWrapper(Bukkit.getAsyncScheduler().runNow(this.plugin, this.runnableToConsumer(task)));
    }

    @Override
    public ITaskWrapper syncLater(@NotNull Runnable task, long delayTicks) {
        return new FoliaTaskWrapper(Bukkit.getGlobalRegionScheduler().runDelayed(this.plugin, this.runnableToConsumer(task), this.toSafeTick(delayTicks)));
    }

    @Override
    public ITaskWrapper asyncLater(@NotNull Runnable task, long delayTicks) {
        return new FoliaTaskWrapper(Bukkit.getAsyncScheduler().runDelayed(this.plugin, this.runnableToConsumer(task), this.toSafeTick(delayTicks) * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public ITaskWrapper syncTimer(@NotNull Runnable task, long delayTicks, long periodTicks) {
        return new FoliaTaskWrapper(Bukkit.getGlobalRegionScheduler().runAtFixedRate(this.plugin, this.runnableToConsumer(task), this.toSafeTick(delayTicks), this.toSafeTick(periodTicks)));
    }

    @Override
    public ITaskWrapper asyncTimer(@NotNull Runnable task, long delayTicks, long periodTicks) {
        return new FoliaTaskWrapper(Bukkit.getAsyncScheduler().runAtFixedRate(this.plugin, this.runnableToConsumer(task), this.toSafeTick(delayTicks) * 50L, this.toSafeTick(periodTicks) * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public ITaskWrapper runOnEntity(Entity entity, Runnable task, Runnable retriedTask) {
        return new FoliaTaskWrapper(entity.getScheduler().run(this.plugin, this.runnableToConsumer(task), retriedTask));
    }

    @Override
    public ITaskWrapper runOnEntityLater(Entity entity, Runnable task, Runnable retriedTask, long delayTicks) {
        return new FoliaTaskWrapper(entity.getScheduler().runDelayed(this.plugin, this.runnableToConsumer(task), retriedTask, this.toSafeTick(delayTicks)));
    }

    @Override
    public ITaskWrapper runOnEntityTimer(Entity entity, Runnable task, Runnable retriedTask, long delayTicks, long periodTicks) {
        return new FoliaTaskWrapper(entity.getScheduler().runAtFixedRate(this.plugin, this.runnableToConsumer(task), retriedTask, this.toSafeTick(delayTicks), this.toSafeTick(periodTicks)));
    }

    @Override
    public ITaskWrapper runOnLocation(Location location, Runnable task) {
        return new FoliaTaskWrapper(Bukkit.getRegionScheduler().run(this.plugin, location, this.runnableToConsumer(task)));
    }

    @Override
    public ITaskWrapper runOnLocationLater(Location location, Runnable task, long delayTicks) {
        return new FoliaTaskWrapper(Bukkit.getRegionScheduler().runDelayed(this.plugin, location, this.runnableToConsumer(task), this.toSafeTick(delayTicks)));
    }

    @Override
    public ITaskWrapper runOnLocationTimer(Location location, Runnable task, long delayTicks, long periodTicks) {
        return new FoliaTaskWrapper(Bukkit.getRegionScheduler().runAtFixedRate(this.plugin, location, this.runnableToConsumer(task), this.toSafeTick(delayTicks), this.toSafeTick(periodTicks)));
    }

    @Override
    public void cancelTasks() {
        Bukkit.getGlobalRegionScheduler().cancelTasks(this.plugin);
        Bukkit.getAsyncScheduler().cancelTasks(this.plugin);
    }

    private Consumer<ScheduledTask> runnableToConsumer(Runnable runnable) {
        return task -> runnable.run();
    }

    private long toSafeTick(long originTick) {
        return originTick > 0L ? originTick : 1L;
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        this.plugin = plugin;
    }
}

