/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.ui.display;

import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Icon {
    private ItemStack display;
    private Consumer<InventoryClickEvent> clickAction;
    @Nullable
    private Player parsePlayer;

    public Icon(@NotNull IconDisplay iconDisplay) {
        this.display = iconDisplay.display();
    }

    public Icon(@NotNull ItemStack display) {
        this(display, null);
    }

    public Icon(@NotNull ItemStack origin, @Nullable IconDisplay iconDisplay) {
        if (!ItemHelper.isAir(origin)) {
            ItemStack originClone = origin.clone();
            this.display = iconDisplay != null ? iconDisplay.applyToItemStack(originClone) : originClone;
        } else {
            this.display = origin;
        }
    }

    public Icon onClick(InventoryClickEvent event) {
        if (this.clickAction == null) {
            event.setCancelled(true);
            return this;
        }
        this.clickAction.accept(event);
        return this;
    }

    public ItemStack display() {
        return this.display;
    }

    public Icon setDisplay(@NotNull ItemStack display) {
        this.display = display;
        return this;
    }

    @Nullable
    public Consumer<InventoryClickEvent> clickAction() {
        return this.clickAction;
    }

    public Icon setClickAction(@Nullable Consumer<InventoryClickEvent> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public Icon setName(String name) {
        ItemHelper.setDisplayName(this.display, name);
        return this;
    }

    public Icon setLore(List<String> lore) {
        ItemHelper.setLore(this.display, lore);
        return this;
    }

    @Nullable
    public Player parsePlayer() {
        return this.parsePlayer;
    }

    public Icon setParsePlayer(@Nullable Player parsePlayer) {
        this.parsePlayer = parsePlayer;
        return this;
    }
}

