/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.ui.display;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconDisplay {
    @NotNull
    protected Material material;
    @Nullable
    protected String name;
    @Nullable
    protected List<String> lore;
    @Nullable
    protected Integer customModelData;
    @Nullable
    protected ItemStack display;

    public IconDisplay(@NotNull Material material) {
        this(material, null, null, null);
    }

    public IconDisplay(@NotNull Material material, @Nullable List<String> lore, @Nullable Integer customModelData) {
        this(material, null, lore, customModelData);
    }

    public IconDisplay(@NotNull Material material, @Nullable String name, @Nullable Integer customModelData) {
        this(material, name, null, customModelData);
    }

    public IconDisplay(@NotNull Material material, @Nullable Integer customModelData) {
        this(material, null, null, customModelData);
    }

    public IconDisplay(@NotNull Material material, @Nullable List<String> lore) {
        this(material, null, lore, null);
    }

    public IconDisplay(@NotNull Material material, @Nullable String name) {
        this(material, name, null, null);
    }

    public IconDisplay(@NotNull Material material, @Nullable String name, @Nullable List<String> lore) {
        this(material, name, lore, null);
    }

    public IconDisplay(@NotNull Material material, @Nullable String name, @Nullable List<String> lore, @Nullable Integer customModelData) {
        this.material = material;
        this.name = name;
        this.lore = lore;
        this.customModelData = customModelData;
    }

    @NotNull
    public Material material() {
        return this.material;
    }

    public IconDisplay setMaterial(@NotNull Material material) {
        this.material = material;
        return this;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public IconDisplay setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public List<String> lore() {
        return this.lore;
    }

    public IconDisplay setLore(@Nullable List<String> lore) {
        this.lore = lore;
        return this;
    }

    public Integer customModelData() {
        return this.customModelData;
    }

    public IconDisplay setCustomModelData(@Nullable Integer customModelData) {
        this.customModelData = customModelData;
        return this;
    }

    @NotNull
    public ItemStack display() {
        if (this.display == null) {
            this.display = this.toItemStack();
        }
        return this.display;
    }

    @NotNull
    public ItemStack toItemStack() {
        ItemStack itemStack = new ItemStack(this.material);
        return this.applyToItemStack(itemStack);
    }

    @NotNull
    public ItemStack applyToItemStack(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        if (this.name != null) {
            itemMeta.setDisplayName(this.name);
        }
        if (this.lore != null) {
            itemMeta.setLore(this.lore);
        }
        if (this.customModelData != null) {
            itemMeta.setCustomModelData(this.customModelData);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

