/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu;

import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitMsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.Menu;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class CooldownMenu
extends Menu {
    private final int cooldownTick;
    private final String cooldownMessage;
    private long lastClick = 0L;

    public CooldownMenu(@NotNull Player player, @NotNull MenuDisplay display, int cooldownTick, String cooldownMessage) {
        super(player, display);
        this.cooldownTick = cooldownTick;
        this.cooldownMessage = cooldownMessage;
    }

    @Override
    public Icon onClick(int slot, InventoryClickEvent event) {
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            event.setCancelled(true);
            return null;
        }
        if (!this.slotMap.containsKey(slot)) {
            event.setCancelled(true);
            return null;
        }
        event.setCancelled(true);
        long current = System.currentTimeMillis();
        long cooldown = (long)this.cooldownTick * 50L - (current - this.lastClick);
        if (cooldown > 0L) {
            BukkitMsgSender.INSTANCE.sendMsg(this.player, String.format(this.cooldownMessage, (double)cooldown / 1000.0));
            return null;
        }
        this.lastClick = current;
        return ((Icon)this.slotMap.get(slot)).onClick(event);
    }
}

