/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.task.ITaskWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.InventoryViewHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Menu
implements InventoryHolder {
    protected final Map<Integer, Icon> slotMap;
    protected final Player player;
    protected MenuDisplay display;
    protected final Map<Character, List<Integer>> layoutSlotMap;
    protected Inventory inventoryCache;

    public Menu(@NotNull Player player) {
        this(player, new MenuDisplay());
    }

    public Menu(@NotNull Player player, @NotNull Supplier<MenuDisplay> displaySupplier) {
        this(player, displaySupplier.get());
    }

    public Menu(@NotNull Player player, @NotNull MenuDisplay display) {
        this.player = player;
        this.display = display;
        this.slotMap = new LinkedHashMap<Integer, Icon>();
        this.layoutSlotMap = new LinkedHashMap<Character, List<Integer>>();
    }

    public Icon onClick(int slot, InventoryClickEvent event) {
        Inventory topInv = InventoryViewHelper.getTopInventory((InventoryEvent)event);
        if (!topInv.equals(event.getClickedInventory())) {
            event.setCancelled(true);
            return null;
        }
        if (!this.slotMap.containsKey(slot)) {
            event.setCancelled(true);
            return null;
        }
        event.setCancelled(true);
        return this.slotMap.get(slot).onClick(event);
    }

    public void onDrag(InventoryDragEvent event) {
    }

    public void onOpen(InventoryOpenEvent event) {
    }

    public void onClose(InventoryCloseEvent event) {
    }

    public Menu openMenu() {
        if (this.inventoryCache == null) {
            this.inventoryCache = this.getInventory();
        }
        this.player.openInventory(this.inventoryCache);
        return this;
    }

    public ITaskWrapper openMenuAsync() {
        return CrypticLibBukkit.scheduler().async(() -> {
            if (this.inventoryCache == null) {
                this.inventoryCache = this.getInventory();
            }
            CrypticLibBukkit.scheduler().sync(() -> this.player.openInventory(this.inventoryCache));
        });
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory;
        this.updateLayout();
        int size = Math.min(this.display.layout().layout().size() * 9, 54);
        if (this.inventoryCache == null) {
            inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)this.formattedTitle());
        } else {
            inventory = this.inventoryCache;
            this.updateMenuTitle();
        }
        this.draw(inventory);
        return inventory;
    }

    public void beforeUpdateLayout() {
    }

    public void updateLayout() {
        this.slotMap.clear();
        this.layoutSlotMap.clear();
        this.beforeUpdateLayout();
        MenuLayout layout = this.display.layout();
        for (int x = 0; x < layout.layout().size(); ++x) {
            String line = layout.layout().get(x);
            for (int y = 0; y < Math.min(line.length(), 9); ++y) {
                char key = line.charAt(y);
                if (!layout.layoutMap().containsKey(Character.valueOf(key))) continue;
                int slot = x * 9 + y;
                if (this.layoutSlotMap.get(Character.valueOf(key)) == null) {
                    this.layoutSlotMap.put(Character.valueOf(key), new ArrayList<Integer>(Collections.singletonList(slot)));
                } else {
                    this.layoutSlotMap.get(Character.valueOf(key)).add(slot);
                }
                Icon icon = layout.layoutMap().get(Character.valueOf(key)).get();
                icon.setParsePlayer(this.player);
                this.preProcessIconWhenUpdateLayout(slot, icon);
                this.slotMap.put(slot, icon);
            }
        }
        this.onLayoutUpdated();
    }

    public void preProcessIconWhenUpdateLayout(Integer slot, @NotNull Icon icon) {
    }

    public void onLayoutUpdated() {
    }

    public void updateMenuIcons() {
        if (this.inventoryCache != null) {
            this.inventoryCache.clear();
            this.draw(this.inventoryCache);
        }
    }

    public void updateMenuTitle() {
        Object inventoryView = InventoryViewHelper.getOpenInventory((HumanEntity)this.player);
        Inventory topInventory = InventoryViewHelper.getTopInventory((HumanEntity)this.player);
        if (topInventory.getHolder() != null && topInventory.getHolder() instanceof Menu) {
            InventoryViewHelper.setTitle(inventoryView, this.formattedTitle());
        }
    }

    public void updateMenu() {
        this.updateMenu(false);
    }

    public void updateMenu(boolean updateLayout) {
        if (updateLayout) {
            this.updateLayout();
        }
        this.updateMenuIcons();
        this.updateMenuTitle();
    }

    public void updateIcons(char iconKey) {
        if (this.inventoryCache == null) {
            return;
        }
        List<Integer> slots = this.getSlots(Character.valueOf(iconKey));
        if (slots == null || slots.isEmpty()) {
            return;
        }
        for (Integer slot : slots) {
            Icon icon = this.slotMap.get(slot);
            if (icon == null) continue;
            this.inventoryCache.setItem(slot.intValue(), icon.display());
        }
    }

    public void updateIcon(int slot) {
        if (this.inventoryCache == null) {
            return;
        }
        Icon icon = this.slotMap.get(slot);
        if (icon != null) {
            this.inventoryCache.setItem(slot, icon.display());
        }
    }

    public void beforeDraw() {
    }

    protected void draw(Inventory inventory) {
        this.beforeDraw();
        this.slotMap.forEach((slot, icon) -> {
            if (icon == null) {
                return;
            }
            this.preProcessIconWhenDraw((Integer)slot, (Icon)icon);
            ItemStack display = icon.display().clone();
            ItemMeta meta = display.getItemMeta();
            if (meta != null) {
                if (meta.hasDisplayName()) {
                    meta.setDisplayName(BukkitTextProcessor.color(BukkitTextProcessor.placeholder((OfflinePlayer)this.player, meta.getDisplayName())));
                }
                if (meta.hasLore()) {
                    List lore = meta.getLore();
                    if (lore != null) {
                        lore.replaceAll(source -> BukkitTextProcessor.color(BukkitTextProcessor.placeholder((OfflinePlayer)this.player, source)));
                    }
                    meta.setLore(lore);
                }
                display.setItemMeta(meta);
            }
            inventory.setItem(slot.intValue(), display);
        });
        this.onDrawCompleted();
    }

    public void preProcessIconWhenDraw(Integer slot, @NotNull Icon icon) {
    }

    public void onDrawCompleted() {
    }

    @NotNull
    public Map<Integer, Icon> slotMap() {
        return this.slotMap;
    }

    @Nullable
    public List<Integer> getSlots(Character key) {
        return this.layoutSlotMap.get(key);
    }

    @Nullable
    public Icon getIcon(int slot) {
        return this.slotMap.get(slot);
    }

    @Nullable
    public Icon setIcon(int slot, Icon icon) {
        if (this.inventoryCache != null) {
            this.inventoryCache.setItem(slot, icon.display());
        }
        return this.slotMap.put(slot, icon);
    }

    @Nullable
    public Icon removeIcon(int slot) {
        if (this.inventoryCache != null) {
            this.inventoryCache.setItem(slot, new ItemStack(Material.AIR));
        }
        return this.slotMap.remove(slot);
    }

    public String formattedTitle() {
        return BukkitTextProcessor.color(BukkitTextProcessor.placeholder((OfflinePlayer)this.player, this.display.title()));
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    @NotNull
    public MenuDisplay display() {
        return this.display;
    }

    public Menu setDisplay(@NotNull MenuDisplay display) {
        this.display = display;
        this.updateLayout();
        return this;
    }

    @Nullable
    public Inventory inventoryCache() {
        return this.inventoryCache;
    }
}

