/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu;

import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.Menu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.InventoryViewHelper;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StoredMenu
extends Menu {
    protected final Map<Integer, ItemStack> storedItems = new ConcurrentHashMap<Integer, ItemStack>();
    protected Boolean returnStoredItems = true;

    public StoredMenu(@NotNull Player player) {
        super(player);
    }

    public StoredMenu(@NotNull Player player, @NotNull Supplier<MenuDisplay> displaySupplier) {
        super(player, displaySupplier);
    }

    public StoredMenu(@NotNull Player player, @NotNull MenuDisplay display) {
        super(player, display);
    }

    @Override
    public Icon onClick(int slot, InventoryClickEvent event) {
        InventoryAction action = event.getAction();
        Inventory topInv = InventoryViewHelper.getTopInventory((InventoryEvent)event);
        if (!topInv.equals(event.getClickedInventory())) {
            if (action.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || action.equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
                event.setCancelled(true);
            }
            return null;
        }
        if (!this.slotMap.containsKey(slot)) {
            if (action.equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
                event.setCancelled(true);
            }
            return null;
        }
        event.setCancelled(true);
        this.refreshStoredItems(event.getClickedInventory());
        return ((Icon)this.slotMap.get(slot)).onClick(event);
    }

    public StoredMenu refreshStoredItems(@NotNull Inventory inventory) {
        this.storedItems.clear();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (this.slotMap.containsKey(i) || ItemHelper.isAir(inventory.getItem(i))) continue;
            this.storedItems.put(i, inventory.getItem(i));
        }
        return this;
    }

    public void returnStoredItems() {
        if (!this.returnStoredItems.booleanValue()) {
            return;
        }
        ItemStack[] returnItems = new ItemStack[this.storedItems.size()];
        int i = 0;
        for (Integer slot : this.storedItems.keySet()) {
            ItemStack item;
            returnItems[i] = item = this.storedItems.get(slot);
            ++i;
        }
        HashMap failedItems = this.player.getInventory().addItem(returnItems);
        if (failedItems.isEmpty()) {
            return;
        }
        for (ItemStack item : failedItems.values()) {
            this.player().getWorld().dropItem(this.player().getLocation(), item);
        }
        this.storedItems.clear();
    }

    @Override
    public StoredMenu openMenu() {
        return (StoredMenu)super.openMenu();
    }

    @Override
    public StoredMenu setDisplay(@NotNull MenuDisplay display) {
        return (StoredMenu)super.setDisplay(display);
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
        if (event.getWhoClicked().getInventory().equals(event.getInventory())) {
            return;
        }
        for (Integer slot : event.getInventorySlots()) {
            ItemStack current = event.getInventory().getItem(slot.intValue());
            if (!event.getOldCursor().isSimilar(current)) continue;
            event.setCancelled(true);
            return;
        }
        this.refreshStoredItems(event.getInventory());
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        this.refreshStoredItems(event.getInventory());
        super.onClose(event);
        this.returnStoredItems();
    }

    @NotNull
    public Map<Integer, ItemStack> storedItems() {
        return this.storedItems;
    }

    public Boolean isReturnStoredItems() {
        return this.returnStoredItems;
    }

    public StoredMenu setReturnStoredItems(Boolean returnStoredItems) {
        this.returnStoredItems = returnStoredItems;
        return this;
    }
}

