/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class FunctionExecutor {
    public static long execute(Runnable task) {
        long startTime = System.nanoTime();
        task.run();
        return FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime);
    }

    public static <T> long execute(Consumer<T> task, T t) {
        long startTime = System.nanoTime();
        task.accept(t);
        return FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime);
    }

    public static <T1, T2> long execute(BiConsumer<T1, T2> task, T1 t1, T2 t2) {
        long startTime = System.nanoTime();
        task.accept(t1, t2);
        return FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime);
    }

    public static <T, R> ExecutionResult<R> execute(Function<T, R> task, T t) {
        long startTime = System.nanoTime();
        R result = task.apply(t);
        return new ExecutionResult<R>(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    public static <T1, T2, R> ExecutionResult<R> execute(BiFunction<T1, T2, R> task, T1 t1, T2 t2) {
        long startTime = System.nanoTime();
        R result = task.apply(t1, t2);
        return new ExecutionResult<R>(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    public static <R> ExecutionResult<R> execute(Supplier<R> task) {
        long startTime = System.nanoTime();
        R result = task.get();
        return new ExecutionResult<R>(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    public static <T> ExecutionResult<Boolean> execute(Predicate<T> task, T t) {
        long startTime = System.nanoTime();
        boolean result = task.test(t);
        return new ExecutionResult<Boolean>(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    public static <T1, T2> ExecutionResult<Boolean> execute(BiPredicate<T1, T2> task, T1 t1, T2 t2) {
        long startTime = System.nanoTime();
        boolean result = task.test(t1, t2);
        return new ExecutionResult<Boolean>(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    public static <T> ExecutionResult<T> execute(BinaryOperator<T> task, T t1, T t2) {
        long startTime = System.nanoTime();
        Object result = task.apply(t1, t2);
        return new ExecutionResult(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    public static <R> ExecutionResult<R> execute(Callable<R> task) throws Exception {
        long startTime = System.nanoTime();
        R result = task.call();
        return new ExecutionResult<R>(result, FunctionExecutor.nanoTime2Millis(System.nanoTime() - startTime));
    }

    private static long nanoTime2Millis(long nanoTime) {
        return nanoTime / 1000000L;
    }

    public static class ExecutionResult<R> {
        private final R result;
        private final long useTime;

        public ExecutionResult(R result, long useTime) {
            this.result = result;
            this.useTime = useTime;
        }

        public R result() {
            return this.result;
        }

        public long useTime() {
            return this.useTime;
        }
    }
}

