/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import com.github.yufiriamazenta.craftorithm.crypticlib.chat.MsgSender;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOHelper {
    public static final Pattern YAML_FILE_PATTERN = Pattern.compile("^(.*)\\.(yaml|yml)$");
    public static final Pattern JSON_FILE_PATTERN = Pattern.compile("^(.*)\\.(json)$");
    public static final Pattern YAML_AND_JSON_FILE_PATTERN = Pattern.compile("^(.*)\\.(yaml|yml|json)$");
    private static final int BUFFER_SIZE = 8192;
    private static MsgSender<?, ?, ?> msgSender;

    public static List<File> allJsonFiles(@NotNull File folder) {
        return IOHelper.allFiles(folder, JSON_FILE_PATTERN);
    }

    public static List<File> allYamlFiles(@NotNull File folder) {
        return IOHelper.allFiles(folder, YAML_FILE_PATTERN);
    }

    public static List<File> allFiles(@NotNull File folder) {
        return IOHelper.allFiles(folder, null);
    }

    public static List<File> allFiles(@NotNull File folder, @Nullable Pattern fileNamePattern) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (folder.isFile() || !folder.exists()) {
            return fileList;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return fileList;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                fileList.addAll(IOHelper.allFiles(file, fileNamePattern));
                continue;
            }
            if (fileNamePattern != null) {
                Matcher matcher = fileNamePattern.matcher(file.getName());
                if (!matcher.find()) continue;
                fileList.add(file);
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    public static boolean isYamlFile(@NotNull File file) {
        return YAML_FILE_PATTERN.matcher(file.getName()).find();
    }

    public static boolean isJsonFile(@NotNull File file) {
        return JSON_FILE_PATTERN.matcher(file.getName()).find();
    }

    public static boolean createNewFile(@NotNull File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    public static File copyFile(File from, File to) {
        try (FileInputStream fileIn = new FileInputStream(from);
             FileOutputStream fileOut = new FileOutputStream(to);
             FileChannel channelIn = fileIn.getChannel();
             FileChannel channelOut = fileOut.getChannel();){
            channelIn.transferTo(0L, channelIn.size(), channelOut);
        }
        catch (IOException t) {
            t.printStackTrace();
        }
        return to;
    }

    public static void downloadFile(URL url, File out) throws IOException {
        int len;
        out.getParentFile().mkdirs();
        InputStream ins = url.openStream();
        OutputStream outs = Files.newOutputStream(out.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[8192];
        while ((len = ins.read(buffer)) > 0) {
            outs.write(buffer, 0, len);
        }
        outs.close();
        ins.close();
    }

    @Contract(value="null -> null; !null -> !null")
    public static String readFile(File file) {
        String string;
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            string = IOHelper.readFully(fileInputStream, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        fileInputStream.close();
        return string;
    }

    @NotNull
    public static String readFully(InputStream inputStream, Charset charset) throws IOException {
        return new String(IOHelper.readBytes(inputStream), charset);
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((len = inputStream.read(buf)) > 0) {
            stream.write(buf, 0, len);
        }
        return stream.toByteArray();
    }

    public static void info(String msg) {
        msgSender.info(msg);
    }

    public static void info(String msg, Map<String, String> replacements) {
        msgSender.info(msg, replacements);
    }

    public static void debug(String msg) {
        msgSender.debug(msg);
    }

    public static void debug(String msg, Map<String, String> replacements) {
        msgSender.debug(msg, replacements);
    }

    public static void setMsgSender(MsgSender<?, ?, ?> msgSender) {
        if (IOHelper.msgSender != null) {
            throw new UnsupportedOperationException("MsgSender is already set");
        }
        IOHelper.msgSender = msgSender;
    }
}

