/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.google.common.base.Preconditions;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemHelper {
    public static boolean isAir(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }

    public static void setDisplayName(ItemStack item, String displayName) {
        ItemHelper.setDisplayName(item, displayName, true);
    }

    public static void setDisplayName(ItemStack item, String displayName, boolean format) {
        Preconditions.checkArgument((!ItemHelper.isAir(item) ? 1 : 0) != 0, (Object)"Item can not be null");
        ItemMeta meta = item.getItemMeta();
        if (format) {
            displayName = BukkitTextProcessor.color(displayName);
        }
        meta.setDisplayName(displayName);
        item.setItemMeta(meta);
    }

    public static void setLore(ItemStack item, List<String> lore) {
        ItemHelper.setLore(item, lore, true);
    }

    public static void setLore(ItemStack item, List<String> lore, boolean format) {
        Preconditions.checkArgument((!ItemHelper.isAir(item) ? 1 : 0) != 0, (Object)"Item can not be air");
        ItemMeta itemMeta = item.getItemMeta();
        if (format) {
            lore.replaceAll(BukkitTextProcessor::color);
        }
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
    }
}

