/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;

public class MapHelper {
    private static final Pattern KEY_VALUE_TEXT_PATTERN = Pattern.compile("(\"[^\"]*\"|'[^']*'|[^:,{]*):(\"[^\"]*\"|'[^']*'|[^,{}]*)");

    @Contract(value="null -> null; !null -> !null")
    public static Map<String, String> keyValueText2Map(String keyValueText) throws KeyValueTextParseException {
        String[] pairs;
        if (keyValueText == null) {
            return null;
        }
        if ((keyValueText = keyValueText.trim().replaceAll("^\\{", "").replaceAll("}$", "")).isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Matcher matcher = KEY_VALUE_TEXT_PATTERN.matcher(keyValueText);
        while (matcher.find()) {
            String key = MapHelper.unwrapStr(matcher.group(1).trim());
            String value = MapHelper.unwrapStr(matcher.group(2).trim());
            if (key.isEmpty()) {
                throw new KeyValueTextParseException("Key can not be empty", keyValueText);
            }
            if (value.isEmpty() && !keyValueText.contains(":")) {
                throw new KeyValueTextParseException("Can not found value of key: " + key, keyValueText);
            }
            resultMap.put(key, value);
        }
        for (String pair : pairs = keyValueText.split(",")) {
            if (pair.contains(":")) continue;
            throw new KeyValueTextParseException("Format incorrect: missing the separator \":\" at " + pair, keyValueText);
        }
        return resultMap;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String map2KeyValueText(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = MapHelper.wrapStr(entry.getKey());
            String value = MapHelper.wrapStr(entry.getValue());
            result.append(key).append(":").append(value).append(", ");
        }
        result.setLength(result.length() - 2);
        result.append("}");
        return result.toString();
    }

    private static String wrapStr(String originStr) {
        return "\"" + originStr + "\"";
    }

    private static String unwrapStr(String wrappedStr) {
        if (wrappedStr.startsWith("\"") && wrappedStr.endsWith("\"") || wrappedStr.startsWith("'") && wrappedStr.endsWith("'")) {
            wrappedStr = wrappedStr.substring(1, wrappedStr.length() - 1);
        }
        return wrappedStr;
    }

    public static class KeyValueTextParseException
    extends RuntimeException {
        private final String keyValueText;

        public KeyValueTextParseException(String message, String keyValueText) {
            super(message);
            this.keyValueText = keyValueText;
        }

        public String getKeyValueText() {
            return this.keyValueText;
        }
    }
}

