/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import org.bukkit.Material;
import org.jetbrains.annotations.Contract;

public class MaterialHelper {
    public static Material matchMaterial(String materialKey) {
        String[] keySplit = materialKey.split(":");
        if (keySplit.length < 2) {
            return Material.matchMaterial((String)materialKey);
        }
        if (keySplit[0].equalsIgnoreCase("minecraft")) {
            return Material.matchMaterial((String)materialKey);
        }
        Material material = Material.matchMaterial((String)materialKey);
        if (material == null) {
            material = Material.matchMaterial((String)materialKey.replace(":", "_"));
        }
        return material;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String getTranslationKey(Material material) {
        if (material == null) {
            return null;
        }
        if (MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_19_3)) {
            return material.getTranslationKey();
        }
        String materialKey = material.getKey().getKey();
        if (material.isBlock()) {
            return "block.minecraft." + materialKey;
        }
        return "item.minecraft." + materialKey;
    }
}

