/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MatrixHelper {
    public static <T> List<List<T>> removeEmptyColumnAndLine(List<List<T>> matrix) {
        while (!matrix.isEmpty() && matrix.get(0).stream().allMatch(Objects::isNull)) {
            matrix.remove(0);
        }
        while (!matrix.isEmpty() && matrix.get(matrix.size() - 1).stream().allMatch(Objects::isNull)) {
            matrix.remove(matrix.size() - 1);
        }
        int[] startCol = new int[]{0};
        int[] endCol = new int[]{matrix.isEmpty() ? -1 : matrix.get(0).size() - 1};
        while (startCol[0] <= endCol[0] && matrix.stream().allMatch(row -> row.get(startCol[0]) == null)) {
            startCol[0] = startCol[0] + 1;
        }
        while (endCol[0] >= startCol[0] && matrix.stream().allMatch(row -> row.get(endCol[0]) == null)) {
            endCol[0] = endCol[0] - 1;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (List<T> row2 : matrix) {
            ArrayList<T> newRow = new ArrayList<T>(row2.subList(startCol[0], endCol[0] + 1));
            result.add(newRow);
        }
        return result;
    }
}

