/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionHelper {
    private static final Map<String, Map<String, Field>> fieldCaches = new ConcurrentHashMap<String, Map<String, Field>>();
    private static final Map<Class<?>, Object> singletonObjectMap = new ConcurrentHashMap();
    private static Object PLUGIN_INSTANCE = null;

    public static Field getField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        Field cacheField = ReflectionHelper.getFieldCache(clazz, fieldName);
        if (cacheField != null) {
            return cacheField;
        }
        try {
            Field field = clazz.getField(fieldName);
            ReflectionHelper.putFieldCache(clazz, fieldName, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getDeclaredField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        Field cacheField = ReflectionHelper.getFieldCache(clazz, fieldName);
        if (cacheField != null) {
            return cacheField;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            ReflectionHelper.putFieldCache(clazz, fieldName, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getFieldCache(Class<?> clazz, String fieldName) {
        Map<String, Field> classFieldCache;
        String className = clazz.getName();
        if (fieldCaches.containsKey(className) && (classFieldCache = fieldCaches.get(className)).containsKey(fieldName)) {
            return classFieldCache.get(fieldName);
        }
        return null;
    }

    private static void putFieldCache(Class<?> clazz, String fieldName, Field field) {
        String className = clazz.getName();
        if (fieldCaches.containsKey(className)) {
            fieldCaches.get(className).put(fieldName, field);
            return;
        }
        ConcurrentHashMap<String, Field> classFieldCache = new ConcurrentHashMap<String, Field>();
        classFieldCache.put(fieldName, field);
        fieldCaches.put(className, classFieldCache);
    }

    public static <T> T getFieldObj(@NotNull Field field, @Nullable Object owner) {
        try {
            return (T)field.get(owner);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getDeclaredFieldObj(@NotNull Field field, @Nullable Object owner) {
        try {
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... argClasses) {
        try {
            return clazz.getMethod(methodName, argClasses);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getDeclaredMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... argClasses) {
        try {
            return clazz.getDeclaredMethod(methodName, argClasses);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeMethod(@NotNull Method method, @Nullable Object invokeObj, Object ... args) {
        try {
            method.setAccessible(true);
            return method.invoke(invokeObj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeDeclaredMethod(@NotNull Method method, @Nullable Object invokeObj, Object ... args) {
        try {
            method.setAccessible(true);
            return method.invoke(invokeObj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(@NotNull Class<T> clazz, Class<?> ... argClasses) {
        try {
            return clazz.getConstructor(argClasses);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(@NotNull Class<T> obj, Class<?> ... argClasses) {
        try {
            return obj.getDeclaredConstructor(argClasses);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeConstructor(@NotNull Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeDeclaredConstructor(@NotNull Constructor<T> constructor, Object ... args) {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i].getClass();
        }
        Constructor<T> constructor = ReflectionHelper.getConstructor(clazz, argClasses);
        return ReflectionHelper.invokeConstructor(constructor, args);
    }

    public static <T> T newDeclaredInstance(Class<T> clazz, Object ... args) {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i].getClass();
        }
        Constructor<T> constructor = ReflectionHelper.getDeclaredConstructor(clazz, argClasses);
        return ReflectionHelper.invokeDeclaredConstructor(constructor, args);
    }

    public static <T> T getSingletonClassInstance(Class<T> clazz, Object ... objects) throws NoClassDefFoundError, ClassNotFoundException {
        Object object;
        if (PLUGIN_INSTANCE.getClass().isAssignableFrom(clazz)) {
            return (T)PLUGIN_INSTANCE;
        }
        if (singletonObjectMap.containsKey(clazz)) {
            return (T)singletonObjectMap.get(clazz);
        }
        if (clazz.isEnum()) {
            object = clazz.getEnumConstants()[0];
        } else {
            try {
                Field instanceField = ReflectionHelper.getDeclaredField(clazz, "INSTANCE");
                object = Modifier.isStatic(instanceField.getModifiers()) ? (instanceField.getType().equals(clazz) ? instanceField.get(clazz) : ReflectionHelper.newDeclaredInstance(clazz, objects)) : ReflectionHelper.newDeclaredInstance(clazz, objects);
            }
            catch (RuntimeException e) {
                object = ReflectionHelper.newDeclaredInstance(clazz, objects);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                object = ReflectionHelper.newDeclaredInstance(clazz, objects);
            }
        }
        singletonObjectMap.put(clazz, object);
        return object;
    }

    @Deprecated
    public static void setPluginInstance(Object pluginInstance) {
        if (PLUGIN_INSTANCE != null) {
            throw new UnsupportedOperationException("Plugin instance already set");
        }
        PLUGIN_INSTANCE = pluginInstance;
    }

    public static Object getPluginInstance() {
        return PLUGIN_INSTANCE;
    }
}

