/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.hook;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.hook.PluginHooker;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.Nullable;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ACTIVE)})
public enum VaultHooker implements PluginHooker,
BukkitLifeCycleTask
{
    INSTANCE;

    private Object economy = null;
    private Boolean economyHooked;

    @Override
    public String pluginName() {
        return "Vault";
    }

    @Override
    public boolean hook() {
        boolean vaultEnabled = Bukkit.getPluginManager().isPluginEnabled("Vault");
        if (!vaultEnabled) {
            this.economyHooked = false;
            return false;
        }
        RegisteredServiceProvider vaultRsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (vaultRsp == null) {
            this.economyHooked = false;
            return false;
        }
        this.economy = vaultRsp.getProvider();
        this.economyHooked = true;
        return true;
    }

    @Nullable
    public Object economy() {
        return this.economy;
    }

    public boolean isEconomyHooked() {
        return this.economyHooked;
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        if (this.hook()) {
            LangUtils.info(Languages.LOAD_HOOK_PLUGIN_SUCCESS, Map.of("<plugin>", this.pluginName()));
        }
    }
}

