/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.hook.item;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import com.github.yufiriamazenta.craftorithm.hook.item.AzureFlowHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.CraftEngineHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.EcoItemsHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.ExecutableItemsHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.ItemPluginHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.ItemsAdderHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.MMOItemsHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.MythicMobs5Hooker;
import com.github.yufiriamazenta.craftorithm.hook.item.NeigeItemsHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.NexoHooker;
import com.github.yufiriamazenta.craftorithm.hook.item.OraxenHooker;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.item.impl.CraftorithmItemProvider;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ACTIVE), @TaskRule(lifeCycle=LifeCycle.RELOAD)})
public enum ItemPluginHookManager implements BukkitLifeCycleTask
{
    INSTANCE;

    private final Map<String, ItemPluginHooker> itemPluginHookerMap = new ConcurrentHashMap<String, ItemPluginHooker>();

    private ItemPluginHookManager() {
        this.addItemPluginHooker(AzureFlowHooker.INSTANCE);
        this.addItemPluginHooker(EcoItemsHooker.INSTANCE);
        this.addItemPluginHooker(ExecutableItemsHooker.INSTANCE);
        this.addItemPluginHooker(ItemsAdderHooker.INSTANCE);
        this.addItemPluginHooker(MMOItemsHooker.INSTANCE);
        this.addItemPluginHooker(MythicMobs5Hooker.INSTANCE);
        this.addItemPluginHooker(NeigeItemsHooker.INSTANCE);
        this.addItemPluginHooker(NexoHooker.INSTANCE);
        this.addItemPluginHooker(OraxenHooker.INSTANCE);
        this.addItemPluginHooker(CraftEngineHooker.INSTANCE);
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        ItemManager.INSTANCE.resetItemProviders();
        for (String hookPluginName : (List)PluginConfigs.ITEM_PLUGIN_HOOK_PRIORITY.value()) {
            ItemPluginHooker itemPluginHooker = this.getItemPluginHooker(hookPluginName);
            if (itemPluginHooker == null) {
                IOHelper.info("&eUnknown item plugin '" + hookPluginName + "'");
                continue;
            }
            if (!itemPluginHooker.hook()) continue;
            ItemManager.INSTANCE.regItemProvider(itemPluginHooker.itemProvider());
            LangUtils.info(Languages.LOAD_HOOK_PLUGIN_SUCCESS, Map.of("<plugin>", hookPluginName));
        }
        ItemManager.INSTANCE.regItemProvider(CraftorithmItemProvider.INSTANCE);
    }

    public void addItemPluginHooker(ItemPluginHooker hooker) {
        this.itemPluginHookerMap.put(hooker.pluginName(), hooker);
    }

    public ItemPluginHooker getItemPluginHooker(String pluginName) {
        return this.itemPluginHookerMap.get(pluginName);
    }
}

