/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.hook.listener;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ReflectionHelper;
import com.github.yufiriamazenta.craftorithm.hook.listener.RecipeCheckRegisteredListener;
import com.github.yufiriamazenta.craftorithm.hook.listener.RecipeCheckTimedRegisteredListener;
import com.github.yufiriamazenta.craftorithm.util.EventUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.TimedRegisteredListener;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.RELOAD)})
public enum OtherPluginsListenerManager implements BukkitLifeCycleTask
{
    INSTANCE;

    private final Field executorField = ReflectionHelper.getDeclaredField(RegisteredListener.class, "executor");

    public void convertOtherPluginsListeners() {
        for (HandlerList handlerList : this.getCraftEventHandlerLists()) {
            for (RegisteredListener registeredListener : handlerList.getRegisteredListeners()) {
                if (registeredListener.getPlugin().equals((Object)Craftorithm.instance()) || registeredListener instanceof RecipeCheckRegisteredListener || registeredListener instanceof RecipeCheckTimedRegisteredListener) continue;
                handlerList.unregister(registeredListener);
                boolean handled = false;
                try {
                    if (registeredListener instanceof TimedRegisteredListener) {
                        handlerList.register((RegisteredListener)new RecipeCheckTimedRegisteredListener(registeredListener.getListener(), this.getRegisteredListenerExecutor(registeredListener), registeredListener.getPriority(), registeredListener.getPlugin(), registeredListener.isIgnoringCancelled()));
                        handled = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handled) continue;
                handlerList.register((RegisteredListener)new RecipeCheckRegisteredListener(registeredListener.getListener(), this.getRegisteredListenerExecutor(registeredListener), registeredListener.getPriority(), registeredListener.getPlugin(), registeredListener.isIgnoringCancelled()));
            }
        }
    }

    public EventExecutor getRegisteredListenerExecutor(RegisteredListener registeredListener) {
        return (EventExecutor)ReflectionHelper.getDeclaredFieldObj(this.executorField, registeredListener);
    }

    private List<HandlerList> getCraftEventHandlerLists() {
        MinecraftVersion currentVersion;
        ArrayList<HandlerList> handlersLists = new ArrayList<HandlerList>();
        handlersLists.add(CraftItemEvent.getHandlerList());
        handlersLists.add(PrepareItemCraftEvent.getHandlerList());
        handlersLists.add(PrepareSmithingEvent.getHandlerList());
        handlersLists.add(SmithItemEvent.getHandlerList());
        handlersLists.add(FurnaceSmeltEvent.getHandlerList());
        handlersLists.add(BlockCookEvent.getHandlerList());
        if (CrypticLibBukkit.isPaper() && ((Boolean)PluginConfigs.ENABLE_ANVIL_RECIPE.value()).booleanValue()) {
            handlersLists.add(PrepareAnvilEvent.getHandlerList());
        }
        if ((currentVersion = MinecraftVersion.current()).afterOrEquals(MinecraftVersion.V1_17_1)) {
            handlersLists.add(FurnaceStartSmeltEvent.getHandlerList());
        }
        if (currentVersion.afterOrEquals(MinecraftVersion.V1_19_3)) {
            handlersLists.add(CampfireStartEvent.getHandlerList());
        }
        if (EventUtils.hasCrafterCraftEvent.booleanValue()) {
            handlersLists.add(CrafterCraftEvent.getHandlerList());
        }
        return handlersLists;
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        this.convertOtherPluginsListeners();
    }
}

