/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.MaterialHelper;
import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ACTIVE, priority=1), @TaskRule(lifeCycle=LifeCycle.RELOAD, priority=1)})
public enum ItemManager implements BukkitLifeCycleTask
{
    INSTANCE;

    private final Map<String, ItemProvider> itemProviderMap;
    private final Map<String, Integer> customCookingFuelMap;
    private final BukkitConfigWrapper customFuelConfig = new BukkitConfigWrapper((Plugin)Craftorithm.instance(), "custom_fuels.yml");
    private final String BURN_TIME_KEY = "burn_time";

    private ItemManager() {
        this.itemProviderMap = new LinkedHashMap<String, ItemProvider>();
        this.customCookingFuelMap = new ConcurrentHashMap<String, Integer>();
    }

    public void regItemProvider(ItemProvider itemProvider) {
        Preconditions.checkArgument((!itemProvider.namespace().equalsIgnoreCase("minecraft") ? 1 : 0) != 0, (Object)"Item provider cannot use namespace minecraft");
        this.itemProviderMap.put(itemProvider.namespace(), itemProvider);
    }

    @NotNull
    public ItemStack matchItem(String itemKey) {
        return this.matchItem(itemKey, null);
    }

    @NotNull
    public ItemStack matchItem(String itemKey, @Nullable OfflinePlayer player) {
        int lastSpaceIndex = itemKey.lastIndexOf(" ");
        int amountScale = 1;
        if (lastSpaceIndex > 0) {
            amountScale = Integer.parseInt(itemKey.substring(lastSpaceIndex + 1));
            itemKey = itemKey.substring(0, lastSpaceIndex);
        }
        if (!(itemKey = itemKey.replace(" ", "")).contains(":")) {
            return this.matchVanillaItem(itemKey, amountScale);
        }
        int index = itemKey.indexOf(":");
        String namespace = itemKey.substring(0, index);
        String name = itemKey.substring(index + 1);
        ItemProvider provider = this.itemProviderMap.get(namespace);
        if (provider == null) {
            return this.matchVanillaItem(itemKey, amountScale);
        }
        ItemStack item = player != null ? provider.getItem(name, player) : provider.getItem(name);
        if (item == null) {
            throw new IllegalArgumentException("Can not found item " + name + " from provider: " + namespace);
        }
        item.setAmount(item.getAmount() * amountScale);
        return item;
    }

    @Nullable
    public String matchItemName(ItemStack item, boolean ignoreAmount) {
        if (ItemHelper.isAir(item)) {
            return null;
        }
        for (Map.Entry<String, ItemProvider> itemProviderEntry : this.itemProviderMap.entrySet()) {
            String tmpName = itemProviderEntry.getValue().getItemName(item, ignoreAmount);
            if (tmpName == null) continue;
            return itemProviderEntry.getKey() + ":" + tmpName;
        }
        return null;
    }

    public ItemStack matchVanillaItem(String itemKey, int amount) {
        Material material = MaterialHelper.matchMaterial(itemKey);
        if (material == null) {
            throw new IllegalArgumentException("Can not found item " + itemKey);
        }
        return new ItemStack(material, amount);
    }

    public void reloadCustomCookingFuel() {
        this.customFuelConfig.reloadConfig();
        this.customCookingFuelMap.clear();
        YamlConfiguration config = (YamlConfiguration)this.customFuelConfig.config();
        Set keys = config.getKeys(false);
        for (String fuel : keys) {
            int time;
            ConfigurationSection fuelConfig = config.getConfigurationSection(fuel);
            if (fuelConfig == null || (time = fuelConfig.getInt("burn_time", 200)) == 0) continue;
            this.customCookingFuelMap.put(fuel, time);
        }
    }

    public boolean isCustomFuel(ItemStack item) {
        if (this.customCookingFuelMap.isEmpty()) {
            return false;
        }
        Integer time = this.matchCustomFuelBurnTime(item);
        return time != null && time > 0;
    }

    public Integer matchCustomFuelBurnTime(ItemStack item) {
        if (this.customCookingFuelMap.isEmpty()) {
            return null;
        }
        String itemName = this.matchItemName(item, true);
        if (itemName == null) {
            itemName = item.getType().getKey().toString();
        }
        return this.customCookingFuelMap.get(itemName);
    }

    public boolean addCustomFuel(ItemStack item, int burnTime) {
        String itemName = ItemUtils.matchItemNameOrCreate(item, true);
        if (itemName == null) {
            throw new IllegalArgumentException("Cannot add null item as a fuel");
        }
        if (this.customCookingFuelMap.containsKey(itemName)) {
            return false;
        }
        this.customCookingFuelMap.put(itemName, burnTime);
        ((YamlConfiguration)this.customFuelConfig.config()).set(itemName + ".burn_time", (Object)burnTime);
        this.customFuelConfig.saveConfig();
        this.customFuelConfig.reloadConfig();
        return true;
    }

    public boolean removeCustomFuel(@NotNull String fuelName) {
        if (!this.customCookingFuelMap.containsKey(fuelName)) {
            return false;
        }
        this.customCookingFuelMap.remove(fuelName);
        ((YamlConfiguration)this.customFuelConfig.config()).set(fuelName, null);
        this.customFuelConfig.saveConfig();
        this.customFuelConfig.reloadConfig();
        return true;
    }

    public Map<String, Integer> customCookingFuelMap() {
        return this.customCookingFuelMap;
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        this.reloadCustomCookingFuel();
    }

    public void resetItemProviders() {
        this.itemProviderMap.clear();
    }
}

