/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import io.rokuko.azureflow.api.AzureFlowAPI;
import io.rokuko.azureflow.features.item.AzureFlowItem;
import io.rokuko.azureflow.features.item.factory.AzureFlowItemFactory;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AzureFlowItemProvider implements ItemProvider
{
    INSTANCE;


    @Override
    @NotNull
    public String namespace() {
        return "azureflow";
    }

    @Override
    @Nullable
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        AzureFlowItem azureFlowItem = AzureFlowAPI.toItem((ItemStack)itemStack);
        if (azureFlowItem == null) {
            return null;
        }
        String itemId = azureFlowItem.getUuid();
        if (ignoreAmount) {
            return itemId;
        }
        return itemId + itemStack.getAmount() / Objects.requireNonNull(this.getItem(itemId)).getAmount();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName) {
        AzureFlowItemFactory factory = AzureFlowAPI.getFactory((String)itemName);
        if (factory == null) {
            return null;
        }
        AzureFlowItem azureFlowItem = factory.build();
        return azureFlowItem.staticItemStack();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName, @Nullable OfflinePlayer player) {
        AzureFlowItemFactory factory = AzureFlowAPI.getFactory((String)itemName);
        if (factory == null) {
            return null;
        }
        AzureFlowItem azureFlowItem = factory.build();
        if (player == null) {
            return azureFlowItem.staticItemStack();
        }
        return azureFlowItem.virtualItemStack(player.getPlayer());
    }
}

