/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CraftEngineItemProvider implements ItemProvider
{
    INSTANCE;


    @Override
    @NotNull
    public String namespace() {
        return "craft_engine";
    }

    @Override
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        if (!CraftEngineItems.isCustomItem((ItemStack)itemStack)) {
            return null;
        }
        @Nullable Key craftEngineItemId = CraftEngineItems.getCustomItemId((ItemStack)itemStack);
        if (craftEngineItemId == null) {
            return null;
        }
        String itemId = craftEngineItemId.asString();
        if (ignoreAmount) {
            return itemId;
        }
        return itemId + " " + itemStack.getAmount();
    }

    @Override
    public ItemStack getItem(String itemName) {
        Key craftEngineItemId = Key.from((String)itemName);
        CustomItem craftEngineItem = CraftEngineItems.byId((Key)craftEngineItemId);
        if (craftEngineItem == null) {
            return null;
        }
        return (ItemStack)craftEngineItem.buildItemStack();
    }

    @Override
    public ItemStack getItem(String itemName, OfflinePlayer player) {
        Key craftEngineItemId = Key.from((String)itemName);
        CustomItem craftEngineItem = CraftEngineItems.byId((Key)craftEngineItemId);
        if (craftEngineItem == null) {
            return null;
        }
        if (player == null) {
            return (ItemStack)craftEngineItem.buildItemStack();
        }
        Player bukkitPlayer = player.getPlayer();
        BukkitServerPlayer craftEnginePlayer = BukkitAdaptors.adapt((Player)bukkitPlayer);
        return (ItemStack)craftEngineItem.buildItemStack((net.momirealms.craftengine.core.entity.player.Player)craftEnginePlayer);
    }
}

