/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import com.github.yufiriamazenta.craftorithm.util.CollectionsUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ENABLE), @TaskRule(lifeCycle=LifeCycle.RELOAD)})
public enum CraftorithmItemProvider implements ItemProvider,
BukkitLifeCycleTask
{
    INSTANCE;

    public final File ITEM_FILE_FOLDER = new File(Craftorithm.instance().getDataFolder(), "items");
    private final Map<String, ItemStack> itemMap;
    private final Map<String, BukkitConfigWrapper> itemConfigFileMap = new HashMap<String, BukkitConfigWrapper>();

    private CraftorithmItemProvider() {
        this.itemMap = new ConcurrentHashMap<String, ItemStack>();
    }

    @Override
    @NotNull
    public String namespace() {
        return "items";
    }

    @Override
    @Nullable
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        for (Map.Entry<String, ItemStack> itemStackEntry : this.itemMap.entrySet()) {
            ItemStack item = itemStackEntry.getValue();
            if (!(ignoreAmount ? item.isSimilar(itemStack) : item.equals((Object)itemStack))) continue;
            return itemStackEntry.getKey();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName) {
        ItemStack item = this.itemMap.get(itemName);
        if (item == null) {
            return null;
        }
        return item.clone();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName, OfflinePlayer player) {
        return this.getItem(itemName);
    }

    private void loadItemFiles() {
        boolean mkdirResult;
        this.itemConfigFileMap.clear();
        if (!this.ITEM_FILE_FOLDER.exists() && !(mkdirResult = this.ITEM_FILE_FOLDER.mkdir())) {
            throw new RuntimeException("Create item folder failed");
        }
        List<File> allFiles = IOHelper.allYamlFiles(this.ITEM_FILE_FOLDER);
        if (allFiles.isEmpty()) {
            Craftorithm.instance().saveResource("items/example_item.yml", false);
            allFiles.add(new File(this.ITEM_FILE_FOLDER, "example_item.yml"));
        }
        for (File file : allFiles) {
            String key = file.getPath().substring(this.ITEM_FILE_FOLDER.getPath().length() + 1);
            key = key.replace("\\", "/");
            int lastDotIndex = key.lastIndexOf(".");
            key = key.substring(0, lastDotIndex);
            this.itemConfigFileMap.put(key, new BukkitConfigWrapper(file));
        }
    }

    private void loadItems() {
        this.itemMap.clear();
        for (String namespace : this.itemConfigFileMap.keySet()) {
            BukkitConfigWrapper itemFile = this.itemConfigFileMap.get(namespace);
            Set itemKeySet = ((YamlConfiguration)itemFile.config()).getKeys(false);
            for (String itemKey : itemKeySet) {
                try {
                    ItemStack item = ((YamlConfiguration)itemFile.config()).getItemStack(itemKey);
                    if (item == null) {
                        throw new NullPointerException("Item " + itemKey + " is null");
                    }
                    this.itemMap.put(namespace + ":" + itemKey, item);
                }
                catch (Exception e) {
                    LangUtils.info(Languages.LOAD_ITEM_LOAD_EXCEPTION, CollectionsUtils.newStringHashMap("<item_name>", itemKey));
                    e.printStackTrace();
                }
            }
        }
    }

    public String regCraftorithmItem(String namespace, String itemName, ItemStack item) {
        BukkitConfigWrapper itemConfigFile;
        if (!this.itemConfigFileMap.containsKey(namespace)) {
            File itemFile = new File(this.ITEM_FILE_FOLDER, namespace + ".yml");
            if (!itemFile.exists()) {
                IOHelper.createNewFile(itemFile);
            }
            itemConfigFile = new BukkitConfigWrapper(itemFile);
            this.itemConfigFileMap.put(namespace, itemConfigFile);
        } else {
            itemConfigFile = this.itemConfigFileMap.get(namespace);
        }
        itemConfigFile.set(itemName, item);
        itemConfigFile.saveConfig();
        String key = namespace + ":" + itemName;
        this.itemMap.put(key, item);
        return key;
    }

    public Map<String, ItemStack> itemMap() {
        return new HashMap<String, ItemStack>(this.itemMap);
    }

    public Map<String, BukkitConfigWrapper> itemConfigFileMap() {
        return new HashMap<String, BukkitConfigWrapper>(this.itemConfigFileMap);
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        this.loadItemFiles();
        this.loadItems();
    }
}

