/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import com.willfp.ecoitems.items.EcoItem;
import com.willfp.ecoitems.items.EcoItems;
import com.willfp.ecoitems.items.ItemUtilsKt;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EcoItemsItemProvider implements ItemProvider
{
    INSTANCE;


    @Override
    @NotNull
    public String namespace() {
        return "ecoitems";
    }

    @Override
    @Nullable
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        EcoItem ecoItem = ItemUtilsKt.getEcoItem((ItemStack)itemStack);
        if (ecoItem == null) {
            return null;
        }
        String id = ecoItem.getID();
        if (ignoreAmount) {
            return id;
        }
        return id + " " + itemStack.getAmount() / Objects.requireNonNull(this.getItem(id)).getAmount();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName) {
        EcoItem ecoItem = EcoItems.INSTANCE.getByID(itemName);
        if (ecoItem == null) {
            return null;
        }
        return ecoItem.getItemStack();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName, @Nullable OfflinePlayer player) {
        return this.getItem(itemName);
    }
}

