/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.api.executableitems.config.ExecutableItemsManagerInterface;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ExecutableItemsItemProvider implements ItemProvider
{
    INSTANCE;


    @Override
    @NotNull
    public String namespace() {
        return "executableitems";
    }

    @Override
    @Nullable
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        ExecutableItemsManagerInterface executableItemsManager = ExecutableItemsAPI.getExecutableItemsManager();
        Optional executableItemOpt = executableItemsManager.getExecutableItem(itemStack);
        if (executableItemOpt.isPresent()) {
            ExecutableItemInterface executableItem = (ExecutableItemInterface)executableItemOpt.get();
            String id = executableItem.getId();
            if (ignoreAmount) {
                return id;
            }
            return id + " " + itemStack.getAmount() / Objects.requireNonNull(this.getItem(id)).getAmount();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName) {
        return this.getItem(itemName, null);
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName, @Nullable OfflinePlayer player) {
        ExecutableItemsManagerInterface executableItemsManager = ExecutableItemsAPI.getExecutableItemsManager();
        Optional executableItemOpt = executableItemsManager.getExecutableItem(itemName);
        if (executableItemOpt.isPresent()) {
            ExecutableItemInterface executableItem = (ExecutableItemInterface)executableItemOpt.get();
            return executableItem.buildItem(1, Optional.ofNullable(player == null ? null : player.getPlayer()));
        }
        return null;
    }
}

