/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmoitems.MMOItems;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MMOItemsItemProvider implements ItemProvider
{
    INSTANCE;


    @Override
    @NotNull
    public String namespace() {
        return "mmoitems";
    }

    @Override
    @Nullable
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
        if (!nbtItem.hasType()) {
            return null;
        }
        String type = nbtItem.getType();
        String id = nbtItem.getString("MMOITEMS_ITEM_ID");
        String itemKey = type + ":" + id;
        if (ignoreAmount) {
            return itemKey;
        }
        ItemStack miItem = this.getItem(itemKey);
        if (ItemHelper.isAir(miItem)) {
            return null;
        }
        return itemKey + " " + itemStack.getAmount() / miItem.getAmount();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName) {
        if (!itemName.contains(":")) {
            return null;
        }
        int index = itemName.indexOf(":");
        String type = itemName.substring(0, index);
        String id = itemName.substring(index + 1);
        return MMOItems.plugin.getItem(type, id);
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName, OfflinePlayer player) {
        return this.getItem(itemName);
    }
}

