/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.item.impl;

import com.github.yufiriamazenta.craftorithm.item.ItemProvider;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.ItemExecutor;
import io.lumine.mythic.core.items.MythicItem;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MythicMobsItemProvider implements ItemProvider
{
    INSTANCE;


    @Override
    @NotNull
    public String namespace() {
        return "mythic_mobs";
    }

    @Override
    @Nullable
    public String getItemName(ItemStack itemStack, boolean ignoreAmount) {
        ItemExecutor itemExecutor = MythicBukkit.inst().getItemManager();
        if (!itemExecutor.isMythicItem(itemStack)) {
            return null;
        }
        String mmItemName = itemExecutor.getMythicTypeFromItem(itemStack);
        if (ignoreAmount) {
            return mmItemName;
        }
        ItemStack mmItem = itemExecutor.getItemStack(mmItemName);
        return mmItemName + " " + itemStack.getAmount() / mmItem.getAmount();
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName) {
        ItemExecutor executor = MythicBukkit.inst().getItemManager();
        Optional itemOptional = executor.getItem(itemName);
        if (!itemOptional.isPresent()) {
            return null;
        }
        MythicItem mythicItem = (MythicItem)itemOptional.get();
        int amount = mythicItem.getAmount();
        return BukkitAdapter.adapt((AbstractItemStack)((MythicItem)itemOptional.get()).generateItemStack(amount));
    }

    @Override
    @Nullable
    public ItemStack getItem(String itemName, OfflinePlayer player) {
        return this.getItem(itemName);
    }
}

