/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.listener;

import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeGroup;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.ItemStack;

@EventListener
public enum RandomSmeltHandler implements Listener
{
    INSTANCE;

    private final Map<Block, YamlConfiguration> randomFurnaceBlockMap;
    private final Random random = new Random();

    private RandomSmeltHandler() {
        this.randomFurnaceBlockMap = new HashMap<Block, YamlConfiguration>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFurnaceStartSmelt(FurnaceStartSmeltEvent event) {
        NamespacedKey recipeKey = event.getRecipe().getKey();
        Map randomCookingRecipeGroups = RecipeManager.INSTANCE.recipeMap().getOrDefault((Object)RecipeType.RANDOM_COOKING, new HashMap());
        boolean isRandomCooking = false;
        for (RecipeGroup group : randomCookingRecipeGroups.values()) {
            if (!group.contains(recipeKey)) continue;
            isRandomCooking = true;
            break;
        }
        if (!isRandomCooking) {
            return;
        }
        YamlConfiguration config = RecipeManager.INSTANCE.getRecipeConfig(event.getRecipe().getKey());
        if (config == null) {
            return;
        }
        if (config.getString("type", "shaped").equals("random_cooking")) {
            this.randomFurnaceBlockMap.put(event.getBlock(), config);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFurnaceSmelt(FurnaceSmeltEvent event) {
        if (this.randomFurnaceBlockMap.containsKey(event.getBlock())) {
            List resultList = this.randomFurnaceBlockMap.get(event.getBlock()).getStringList("result");
            List<Map.Entry<ItemStack, Integer>> weightList = this.getWeight(resultList);
            int randomNum = this.random.nextInt(weightList.get(weightList.size() - 1).getValue());
            for (Map.Entry<ItemStack, Integer> entry : weightList) {
                if (randomNum >= entry.getValue()) continue;
                event.setResult(entry.getKey());
                break;
            }
            this.randomFurnaceBlockMap.remove(event.getBlock());
        }
    }

    private List<Map.Entry<ItemStack, Integer>> getWeight(List<String> resultStr) {
        HashMap<ItemStack, Integer> weightMap = new HashMap<ItemStack, Integer>();
        int sum = 0;
        for (String result : resultStr) {
            String item = result.substring(0, result.lastIndexOf(" "));
            int weight = Integer.parseInt(result.substring(result.lastIndexOf(" ") + 1));
            ItemStack itemStack = ItemManager.INSTANCE.matchItem(item);
            weightMap.put(itemStack, sum += weight);
        }
        ArrayList<Map.Entry<ItemStack, Integer>> weightList = new ArrayList<Map.Entry<ItemStack, Integer>>(weightMap.entrySet());
        weightList.sort(Map.Entry.comparingByValue());
        return weightList;
    }
}

