/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.listener;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

@EventListener
public enum SmeltResultRefreshHandler implements Listener
{
    INSTANCE;

    private final Map<Block, Recipe> blockSmeltRecipeMap = new ConcurrentHashMap<Block, Recipe>();

    @EventHandler
    public void putFurnaceSmeltRecipeCache(FurnaceStartSmeltEvent event) {
        if (CrypticLibBukkit.isPaper()) {
            return;
        }
        CookingRecipe recipe = event.getRecipe();
        NamespacedKey namespacedKey = RecipeManager.INSTANCE.getRecipeKey((Recipe)recipe);
        if (!namespacedKey.getNamespace().equals(RecipeManager.INSTANCE.PLUGIN_RECIPE_NAMESPACE)) {
            return;
        }
        this.putRecipeCache(event.getBlock(), recipe);
    }

    @EventHandler
    public void refreshSmeltResult(FurnaceSmeltEvent event) {
        CookingRecipe recipe;
        if (!CrypticLibBukkit.isPaper()) {
            recipe = this.blockSmeltRecipeMap.get(event.getBlock());
            this.blockSmeltRecipeMap.remove(event.getBlock());
        } else {
            recipe = event.getRecipe();
        }
        if (recipe == null) {
            return;
        }
        ItemStack result = event.getResult();
        String id = ItemManager.INSTANCE.matchItemName(result, false);
        if (id == null) {
            return;
        }
        ItemStack refreshItem = ItemManager.INSTANCE.matchItem(id);
        result.setItemMeta(refreshItem.getItemMeta());
        event.setResult(result);
    }

    @EventHandler
    public void putBlockCookRecipeCache(CampfireStartEvent event) {
        if (CrypticLibBukkit.isPaper()) {
            return;
        }
        CampfireRecipe recipe = event.getRecipe();
        NamespacedKey namespacedKey = RecipeManager.INSTANCE.getRecipeKey((Recipe)recipe);
        if (!namespacedKey.getNamespace().equals(RecipeManager.INSTANCE.PLUGIN_RECIPE_NAMESPACE)) {
            return;
        }
        this.putRecipeCache(event.getBlock(), (CookingRecipe<?>)recipe);
    }

    @EventHandler
    public void refreshBlockCookResult(BlockCookEvent event) {
        CookingRecipe recipe;
        if (!CrypticLibBukkit.isPaper()) {
            recipe = this.blockSmeltRecipeMap.get(event.getBlock());
            this.blockSmeltRecipeMap.remove(event.getBlock());
        } else {
            recipe = event.getRecipe();
        }
        if (recipe == null) {
            return;
        }
        ItemStack result = event.getResult();
        String id = ItemManager.INSTANCE.matchItemName(result, false);
        if (id == null) {
            return;
        }
        ItemStack refreshItem = ItemManager.INSTANCE.matchItem(id);
        result.setItemMeta(refreshItem.getItemMeta());
        event.setResult(result);
    }

    private void putRecipeCache(Block block, CookingRecipe<?> recipe) {
        this.blockSmeltRecipeMap.put(block, (Recipe)recipe);
        int cookingTime = recipe.getCookingTime();
        CrypticLibBukkit.scheduler().asyncLater(() -> this.blockSmeltRecipeMap.remove(block), cookingTime + 20);
    }
}

