/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.listener;

import com.github.yufiriamazenta.craftorithm.CraftorithmAPI;
import com.github.yufiriamazenta.craftorithm.arcenciel.ArcencielDispatcher;
import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.InventoryViewHelper;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.util.CollectionsUtils;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;

@EventListener
public enum SmithingHandler implements Listener
{
    INSTANCE;


    @EventHandler(priority=EventPriority.MONITOR)
    public void refreshResult(PrepareSmithingEvent event) {
        ItemStack base;
        boolean copyEnchantment;
        ItemStack refreshItem;
        if (event.getResult() == null) {
            return;
        }
        Recipe recipe = event.getInventory().getRecipe();
        if (recipe == null) {
            return;
        }
        NamespacedKey namespacedKey = RecipeManager.INSTANCE.getRecipeKey(recipe);
        if (!namespacedKey.getNamespace().equals(RecipeManager.INSTANCE.PLUGIN_RECIPE_NAMESPACE)) {
            return;
        }
        ItemStack result = event.getResult();
        String id = ItemManager.INSTANCE.matchItemName(result, false);
        if (id != null && !result.isSimilar(refreshItem = ItemManager.INSTANCE.matchItem(id, (OfflinePlayer)((Player)event.getViewers().get(0))))) {
            result.setItemMeta(refreshItem.getItemMeta());
        }
        if ((copyEnchantment = RecipeManager.INSTANCE.getSmithingCopyEnchantment(recipe)) && (base = event.getInventory().getItem(1)).hasItemMeta()) {
            Map baseEnchantments = base.getItemMeta().getEnchants();
            ItemMeta resultMeta = result.getItemMeta();
            HashMap<Enchantment, Integer> resultEnchantments = new HashMap<Enchantment, Integer>(resultMeta.getEnchants());
            CollectionsUtils.putAllIf(resultEnchantments, baseEnchantments, (type, level) -> {
                if (resultEnchantments.containsKey(type)) {
                    return level > (Integer)resultEnchantments.get(type);
                }
                return true;
            });
            resultMeta.getEnchants().forEach((enchant, level) -> resultMeta.removeEnchant(enchant));
            resultEnchantments.forEach((enchant, level) -> resultMeta.addEnchant(enchant, level.intValue(), true));
            result.setItemMeta(resultMeta);
        }
        event.setResult(result);
        event.getInventory().setResult(result);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void runConditions(PrepareSmithingEvent event) {
        NamespacedKey recipeKey = RecipeManager.INSTANCE.getRecipeKey(event.getInventory().getRecipe());
        if (recipeKey == null) {
            return;
        }
        YamlConfiguration config = RecipeManager.INSTANCE.getRecipeConfig(recipeKey);
        if (config == null) {
            return;
        }
        Object inventoryView = InventoryViewHelper.getInventoryView((InventoryEvent)event);
        Player player = (Player)InventoryViewHelper.getViewingPlayer(inventoryView);
        Object condition = config.getString("condition", "true");
        boolean result = (Boolean)ArcencielDispatcher.INSTANCE.dispatchArcencielBlock(player, (String)(condition = "if " + (String)condition)).obj();
        if (!result) {
            event.setResult(null);
            event.getInventory().setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void runActions(SmithItemEvent event) {
        HumanEntity entity = event.getWhoClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        NamespacedKey recipeKey = RecipeManager.INSTANCE.getRecipeKey(event.getInventory().getRecipe());
        if (recipeKey == null) {
            return;
        }
        YamlConfiguration config = RecipeManager.INSTANCE.getRecipeConfig(recipeKey);
        if (config == null) {
            return;
        }
        Player player = (Player)entity;
        List actions = config.getStringList("actions");
        CraftorithmAPI.INSTANCE.arcencielDispatcher().dispatchArcencielFunc(player, actions);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void checkCannotCraftLore(PrepareSmithingEvent event) {
        ItemStack[] items = event.getInventory().getContents();
        boolean containsLore = ItemUtils.hasCannotCraftLore(items);
        if (containsLore) {
            event.getInventory().setResult(null);
            event.setResult(null);
        }
    }
}

