/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.Conversation;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.NumberPrompt;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.Prompt;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.StoredMenu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.RecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeCreator
extends RecipeCreator {
    private boolean copyNbt = true;
    private int costLevel = 0;
    private boolean inConversation = false;

    public AnvilRecipeCreator(@NotNull Player player, @NotNull String recipeName) {
        super(player, RecipeType.ANVIL, recipeName);
        this.setDisplay(new MenuDisplay(this.title(), new MenuLayout(Arrays.asList("####C####", "#***#%%%#", "# * A% %#", "#***#%%%#", "#########"), () -> {
            HashMap<Character, Supplier<Icon>> layoutMap = new HashMap<Character, Supplier<Icon>>();
            layoutMap.put(Character.valueOf('#'), this::getFrameIcon);
            layoutMap.put(Character.valueOf('%'), this::getResultFrameIcon);
            layoutMap.put(Character.valueOf('*'), () -> new Icon(new IconDisplay(Material.CYAN_STAINED_GLASS_PANE, (String)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_FRAME.value(player))));
            layoutMap.put(Character.valueOf('B'), this::getCopyNbtIcon);
            layoutMap.put(Character.valueOf('C'), this::getCostLevelIcon);
            layoutMap.put(Character.valueOf('A'), () -> new Icon(new IconDisplay(Material.ANVIL, (String)Languages.MENU_RECIPE_CREATOR_ICON_CONFIRM.value(player))).setClickAction(event -> {
                StoredMenu creator = (StoredMenu)event.getClickedInventory().getHolder();
                ItemStack result = Objects.requireNonNull(creator).storedItems().get(24);
                ItemStack base = creator.storedItems().get(19);
                ItemStack addition = creator.storedItems().get(21);
                if (ItemHelper.isAir(result)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_RESULT);
                    return;
                }
                if (ItemHelper.isAir(addition) || ItemHelper.isAir(base)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                String resultName = ItemUtils.matchItemNameOrCreate(result, false);
                String inputName = ItemUtils.matchItemNameOrCreate(base, false);
                String ingredientName = ItemUtils.matchItemNameOrCreate(addition, false);
                BukkitConfigWrapper recipeConfig = this.createRecipeConfig(recipeName);
                recipeConfig.set("source.copy_nbt", event.getInventory().getItem(40).getItemMeta().hasEnchants());
                recipeConfig.set("type", "anvil");
                recipeConfig.set("source.base", inputName);
                recipeConfig.set("source.addition", ingredientName);
                recipeConfig.set("source.cost_level", this.costLevel);
                recipeConfig.set("result", resultName);
                recipeConfig.saveConfig();
                recipeConfig.reloadConfig();
                this.regRecipeGroup(recipeConfig);
                event.getWhoClicked().closeInventory();
                this.sendSuccessMsg((HumanEntity)player, recipeName);
            }));
            return layoutMap;
        })));
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        if (!this.inConversation) {
            super.onClose(event);
        } else {
            this.refreshStoredItems(event.getInventory());
        }
    }

    protected Icon getCopyNbtIcon() {
        Icon icon = new Icon(new IconDisplay(Material.NAME_TAG, ((String)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_COPY_NBT_TOGGLE.value(this.player)).replace("<enable>", String.valueOf(this.copyNbt)))).setClickAction(event -> this.toggleCopyNbt(event.getSlot(), (InventoryClickEvent)event));
        if (this.copyNbt) {
            ItemUtils.toggleItemGlowing(icon.display());
        }
        return icon;
    }

    protected void toggleCopyNbt(int slot, InventoryClickEvent event) {
        super.toggleIconGlowing(slot, event);
        this.copyNbt = !this.copyNbt;
        ItemStack display = event.getCurrentItem();
        ItemHelper.setDisplayName(display, ((String)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_COPY_NBT_TOGGLE.value(this.player)).replace("<enable>", String.valueOf(this.copyNbt)));
    }

    protected Icon getCostLevelIcon() {
        return new Icon(new IconDisplay(Material.EXPERIENCE_BOTTLE, ((String)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_COST_LEVEL_NAME.value(this.player)).replace("<level>", String.valueOf(this.costLevel)), (List)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_COST_LEVEL_LORE.value(this.player))).setClickAction(event -> {
            Conversation conversation = new Conversation((Plugin)Craftorithm.instance(), this.player, (Prompt)new CostLevelInputPrompt(), data -> this.player.openInventory(this.inventoryCache));
            this.inConversation = true;
            conversation.start();
            this.player.closeInventory();
        });
    }

    public void updateCostLevelIcon() {
        ItemStack costLevelIcon = this.inventoryCache.getItem(4);
        if (costLevelIcon == null) {
            return;
        }
        ItemHelper.setDisplayName(costLevelIcon, ((String)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_COST_LEVEL_NAME.value(this.player)).replace("<level>", String.valueOf(this.costLevel)));
    }

    class CostLevelInputPrompt
    implements NumberPrompt {
        CostLevelInputPrompt() {
        }

        @Override
        @Nullable
        public Prompt acceptValidatedInput(@NotNull Map<Object, Object> data, @NotNull Number number) {
            AnvilRecipeCreator.this.costLevel = number.intValue();
            AnvilRecipeCreator.this.player.openInventory(AnvilRecipeCreator.this.inventoryCache);
            AnvilRecipeCreator.this.updateCostLevelIcon();
            AnvilRecipeCreator.this.inConversation = false;
            return null;
        }

        @Override
        @NotNull
        public BaseComponent promptText(@NotNull Map<Object, Object> data) {
            return BukkitTextProcessor.toComponent(BukkitTextProcessor.color((String)Languages.MENU_RECIPE_CREATOR_ICON_ANVIL_COST_LEVEL_INPUT_HINT.value(AnvilRecipeCreator.this.player)));
        }
    }
}

