/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.Conversation;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.NumberPrompt;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.Prompt;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.StoredMenu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.UnlockableRecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingRecipeCreator
extends UnlockableRecipeCreator {
    private final Map<Material, Boolean> cookingToggleMap = new HashMap<Material, Boolean>();
    private int cookingTime = 200;
    private float exp = 0.0f;
    private boolean inConversation = false;

    public CookingRecipeCreator(@NotNull Player player, @NotNull String recipeName) {
        super(player, RecipeType.COOKING, recipeName);
        this.cookingToggleMap.put(Material.FURNACE, true);
        this.cookingToggleMap.put(Material.BLAST_FURNACE, false);
        this.cookingToggleMap.put(Material.SMOKER, false);
        this.cookingToggleMap.put(Material.CAMPFIRE, false);
        this.setDisplay(new MenuDisplay(this.title(), new MenuLayout(Arrays.asList("###GFH###", "#***#%%%#", "#* *A% %#", "#***#%%%#", "##BC#DE##"), () -> {
            HashMap<Character, Supplier<Icon>> layoutMap = new HashMap<Character, Supplier<Icon>>();
            layoutMap.put(Character.valueOf('#'), this::getFrameIcon);
            layoutMap.put(Character.valueOf('%'), this::getResultFrameIcon);
            layoutMap.put(Character.valueOf('*'), () -> new Icon(new IconDisplay(Material.CYAN_STAINED_GLASS_PANE, (String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_FRAME.value(player))));
            layoutMap.put(Character.valueOf('B'), () -> this.getCookingToggleIcon(Material.FURNACE));
            layoutMap.put(Character.valueOf('C'), () -> this.getCookingToggleIcon(Material.BLAST_FURNACE));
            layoutMap.put(Character.valueOf('D'), () -> this.getCookingToggleIcon(Material.SMOKER));
            layoutMap.put(Character.valueOf('E'), () -> this.getCookingToggleIcon(Material.CAMPFIRE));
            layoutMap.put(Character.valueOf('F'), this::getUnlockIcon);
            layoutMap.put(Character.valueOf('G'), this::getCookingTimeIcon);
            layoutMap.put(Character.valueOf('H'), this::getExpIcon);
            layoutMap.put(Character.valueOf('A'), () -> new Icon(new IconDisplay(Material.FURNACE, (String)Languages.MENU_RECIPE_CREATOR_ICON_CONFIRM.value(player))).setClickAction(event -> {
                StoredMenu creator = (StoredMenu)Objects.requireNonNull(event.getClickedInventory()).getHolder();
                ItemStack source = Objects.requireNonNull(creator).storedItems().get(20);
                ItemStack result = creator.storedItems().get(24);
                if (ItemHelper.isAir(source)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                if (ItemHelper.isAir(result)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_RESULT);
                    return;
                }
                String sourceName = ItemUtils.matchItemNameOrCreate(source, true);
                String resultName = ItemUtils.matchItemNameOrCreate(result, false);
                BukkitConfigWrapper recipeConfig = this.createRecipeConfig(recipeName);
                recipeConfig.set("type", "cooking");
                recipeConfig.set("result", resultName);
                recipeConfig.set("multiple", true);
                ArrayList sourceList = new ArrayList();
                this.cookingToggleMap.forEach((type, enable) -> {
                    if (!enable.booleanValue()) {
                        return;
                    }
                    HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                    sourceMap.put("block", type.name().toLowerCase());
                    sourceMap.put("item", sourceName);
                    sourceMap.put("time", this.cookingTime);
                    sourceMap.put("exp", Float.valueOf(this.exp));
                    sourceList.add(sourceMap);
                });
                recipeConfig.set("unlock", this.unlock());
                recipeConfig.set("source", sourceList);
                recipeConfig.saveConfig();
                recipeConfig.reloadConfig();
                this.regRecipeGroup(recipeConfig);
                event.getWhoClicked().closeInventory();
                this.sendSuccessMsg(event.getWhoClicked(), recipeName);
            }));
            return layoutMap;
        })));
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        if (!this.inConversation) {
            super.onClose(event);
        } else {
            this.refreshStoredItems(event.getInventory());
        }
    }

    protected Icon getCookingToggleIcon(Material material) {
        boolean enable = this.cookingToggleMap.getOrDefault(material, false);
        String displayName = switch (material) {
            default -> (String)Languages.MENU_RECIPE_CREATOR_ICON_FURNACE_TOGGLE.value(this.player);
            case Material.BLAST_FURNACE -> (String)Languages.MENU_RECIPE_CREATOR_ICON_BLAST_FURNACE_TOGGLE.value(this.player);
            case Material.SMOKER -> (String)Languages.MENU_RECIPE_CREATOR_ICON_SMOKER_TOGGLE.value(this.player);
            case Material.CAMPFIRE -> (String)Languages.MENU_RECIPE_CREATOR_ICON_CAMPFIRE_TOGGLE.value(this.player);
        };
        displayName = displayName.replace("<enable>", String.valueOf(enable));
        Icon icon = new Icon(new IconDisplay(material, displayName)).setClickAction(event -> this.toggleCookingIcon(event.getSlot(), (InventoryClickEvent)event));
        if (enable) {
            ItemUtils.toggleItemGlowing(icon.display());
        }
        return icon;
    }

    protected void toggleCookingIcon(int slot, InventoryClickEvent event) {
        super.toggleIconGlowing(slot, event);
        ItemStack display = event.getCurrentItem();
        String displayName = switch (display.getType()) {
            default -> (String)Languages.MENU_RECIPE_CREATOR_ICON_FURNACE_TOGGLE.value(this.player);
            case Material.BLAST_FURNACE -> (String)Languages.MENU_RECIPE_CREATOR_ICON_BLAST_FURNACE_TOGGLE.value(this.player);
            case Material.SMOKER -> (String)Languages.MENU_RECIPE_CREATOR_ICON_SMOKER_TOGGLE.value(this.player);
            case Material.CAMPFIRE -> (String)Languages.MENU_RECIPE_CREATOR_ICON_CAMPFIRE_TOGGLE.value(this.player);
        };
        boolean enable = this.cookingToggleMap.getOrDefault(display.getType(), false) == false;
        this.cookingToggleMap.put(display.getType(), enable);
        ItemHelper.setDisplayName(display, displayName.replace("<enable>", String.valueOf(enable)));
    }

    protected Icon getCookingTimeIcon() {
        return new Icon(new IconDisplay(Material.CLOCK, ((String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_TIME_NAME.value(this.player)).replace("<time>", String.valueOf(this.cookingTime)), (List)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_TIME_LORE.value(this.player))).setClickAction(event -> {
            Conversation timeInputConversation = new Conversation((Plugin)Craftorithm.instance(), this.player, (Prompt)new TimeInputPrompt(), data -> this.player.openInventory(this.inventoryCache));
            this.inConversation = true;
            timeInputConversation.start();
            this.player.closeInventory();
        });
    }

    protected Icon getExpIcon() {
        return new Icon(new IconDisplay(Material.EXPERIENCE_BOTTLE, ((String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_EXP_NAME.value(this.player)).replace("<exp>", String.valueOf(this.exp)), (List)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_EXP_LORE.value(this.player))).setClickAction(event -> {
            Conversation conversation = new Conversation((Plugin)Craftorithm.instance(), this.player, (Prompt)new ExpInputPrompt(), data -> this.player.openInventory(this.inventoryCache));
            this.inConversation = true;
            conversation.start();
            this.player.closeInventory();
        });
    }

    protected void updateCookingTimeIcon() {
        ItemStack cookingTimeIcon = this.inventoryCache.getItem(3);
        if (cookingTimeIcon == null) {
            return;
        }
        ItemHelper.setDisplayName(cookingTimeIcon, ((String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_TIME_NAME.value(this.player)).replace("<time>", String.valueOf(this.cookingTime)));
    }

    protected void updateExpIcon() {
        ItemStack expIcon = this.inventoryCache.getItem(5);
        if (expIcon == null) {
            return;
        }
        ItemHelper.setDisplayName(expIcon, ((String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_EXP_NAME.value(this.player)).replace("<exp>", String.valueOf(this.exp)));
    }

    class ExpInputPrompt
    implements NumberPrompt {
        ExpInputPrompt() {
        }

        @Override
        @Nullable
        public Prompt acceptValidatedInput(@NotNull Map<Object, Object> data, @NotNull Number number) {
            CookingRecipeCreator.this.exp = number.floatValue();
            CookingRecipeCreator.this.updateExpIcon();
            CookingRecipeCreator.this.openMenu();
            CookingRecipeCreator.this.inConversation = false;
            return null;
        }

        @Override
        @NotNull
        public BaseComponent promptText(@NotNull Map<Object, Object> data) {
            return BukkitTextProcessor.toComponent(BukkitTextProcessor.color((String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_EXP_INPUT_HINT.value(CookingRecipeCreator.this.player)));
        }
    }

    class TimeInputPrompt
    implements NumberPrompt {
        TimeInputPrompt() {
        }

        @Override
        @Nullable
        public Prompt acceptValidatedInput(@NotNull Map<Object, Object> data, @NotNull Number number) {
            CookingRecipeCreator.this.cookingTime = number.intValue();
            CookingRecipeCreator.this.updateCookingTimeIcon();
            CookingRecipeCreator.this.openMenu();
            CookingRecipeCreator.this.inConversation = false;
            return null;
        }

        @Override
        @NotNull
        public BaseComponent promptText(@NotNull Map<Object, Object> data) {
            return BukkitTextProcessor.toComponent(BukkitTextProcessor.color((String)Languages.MENU_RECIPE_CREATOR_ICON_COOKING_TIME_INPUT_HINT.value(CookingRecipeCreator.this.player)));
        }
    }
}

