/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.StoredMenu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.UnlockableRecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftingRecipeCreator
extends UnlockableRecipeCreator {
    public CraftingRecipeCreator(@NotNull Player player, RecipeType recipeType, @NotNull String recipeName) {
        super(player, recipeType, recipeName);
        Preconditions.checkArgument((recipeType.equals((Object)RecipeType.SHAPED) || recipeType.equals((Object)RecipeType.SHAPELESS) ? 1 : 0) != 0, (Object)"Crafting recipe only allow shaped and shapeless type");
        this.setDisplay(new MenuDisplay(this.title(), new MenuLayout(Arrays.asList("####F####", "#   #***#", "#   A* *#", "#   #***#", "#########"), () -> {
            HashMap<Character, Supplier<Icon>> layoutMap = new HashMap<Character, Supplier<Icon>>();
            layoutMap.put(Character.valueOf('#'), this::getFrameIcon);
            layoutMap.put(Character.valueOf('*'), this::getResultFrameIcon);
            layoutMap.put(Character.valueOf('F'), this::getUnlockIcon);
            layoutMap.put(Character.valueOf('A'), () -> new Icon(new IconDisplay(Material.CRAFTING_TABLE, (String)Languages.MENU_RECIPE_CREATOR_ICON_CONFIRM.value(player))).setClickAction(event -> {
                StoredMenu creator = (StoredMenu)Objects.requireNonNull(event.getClickedInventory()).getHolder();
                Map<Integer, ItemStack> storedItems = Objects.requireNonNull(creator).storedItems();
                ItemStack result = storedItems.get(24);
                if (ItemHelper.isAir(result)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_RESULT);
                    return;
                }
                String resultName = ItemUtils.matchItemNameOrCreate(result, false);
                int[] sourceSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
                ArrayList<String> sourceList = new ArrayList<String>();
                for (int slot : sourceSlots) {
                    ItemStack source = storedItems.get(slot);
                    if (ItemHelper.isAir(source)) {
                        sourceList.add("");
                        continue;
                    }
                    String sourceName = ItemUtils.matchItemNameOrCreate(source, true);
                    sourceList.add(sourceName);
                }
                boolean allEmpty = true;
                for (String choice : sourceList) {
                    if (choice.isEmpty()) continue;
                    allEmpty = false;
                    break;
                }
                if (allEmpty) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                BukkitConfigWrapper recipeConfig = this.createRecipeConfig(recipeName);
                switch (this.recipeType()) {
                    case SHAPED: {
                        int i;
                        LinkedHashMap<String, Character> itemRepeatMap = new LinkedHashMap<String, Character>();
                        ArrayList<String> shape = new ArrayList<String>();
                        LinkedHashMap itemNameMap = new LinkedHashMap();
                        char[] tmp = "         ".toCharArray();
                        char c = 'a';
                        for (i = 0; i < sourceList.size(); ++i) {
                            String sourceItem = (String)sourceList.get(i);
                            if (sourceItem.isEmpty()) continue;
                            if (!itemRepeatMap.containsKey(sourceItem)) {
                                itemRepeatMap.put(sourceItem, Character.valueOf(c));
                                c = (char)(c + '\u0001');
                            }
                            tmp[i] = ((Character)itemRepeatMap.get(sourceItem)).charValue();
                        }
                        for (i = 0; i < 9; i += 3) {
                            shape.add(new String(tmp, i, 3));
                        }
                        itemRepeatMap.forEach((k, v) -> itemNameMap.put(v, k));
                        shape.removeIf(s -> s.trim().isEmpty());
                        this.removeEmptyColumn(shape);
                        recipeConfig.set("type", "shaped");
                        recipeConfig.set("shape", shape);
                        recipeConfig.set("source", itemNameMap);
                        break;
                    }
                    case SHAPELESS: {
                        sourceList.removeIf(String::isEmpty);
                        recipeConfig.set("type", "shapeless");
                        recipeConfig.set("source", sourceList);
                    }
                }
                recipeConfig.set("unlock", this.unlock());
                recipeConfig.set("result", resultName);
                recipeConfig.saveConfig();
                recipeConfig.reloadConfig();
                this.regRecipeGroup(recipeConfig);
                event.getWhoClicked().closeInventory();
                this.sendSuccessMsg(event.getWhoClicked(), recipeName);
            }));
            return layoutMap;
        })));
    }

    private void removeEmptyColumn(List<String> shape) {
        boolean[] empty = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            int finalI = i;
            empty[i] = shape.stream().allMatch(s -> s.charAt(finalI) == ' ');
        }
        if (empty[0]) {
            if (empty[1]) {
                if (!empty[2]) {
                    shape.replaceAll(s -> s.substring(2));
                }
            } else if (empty[2]) {
                shape.replaceAll(s -> s.substring(1, 2));
            } else {
                shape.replaceAll(s -> s.substring(1));
            }
        } else if (empty[1]) {
            if (empty[2]) {
                shape.replaceAll(s -> s.substring(0, 1));
            }
        } else if (empty[2]) {
            shape.replaceAll(s -> s.substring(0, 2));
        }
    }
}

