/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.StoredMenu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.RecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PotionMixCreator
extends RecipeCreator {
    public PotionMixCreator(@NotNull Player player, @NotNull String recipeName) {
        super(player, RecipeType.POTION, recipeName);
        this.setDisplay(new MenuDisplay(this.title(), new MenuLayout(Arrays.asList("#########", "#***#%%%#", "# * A% %#", "#***#%%%#", "#########"), () -> {
            HashMap<Character, Supplier<Icon>> layoutMap = new HashMap<Character, Supplier<Icon>>();
            layoutMap.put(Character.valueOf('#'), this::getFrameIcon);
            layoutMap.put(Character.valueOf('%'), this::getResultFrameIcon);
            layoutMap.put(Character.valueOf('*'), () -> new Icon(new IconDisplay(Material.CYAN_STAINED_GLASS_PANE, (String)Languages.MENU_RECIPE_CREATOR_ICON_POTION_FRAME.value(player))));
            layoutMap.put(Character.valueOf('A'), () -> new Icon(new IconDisplay(Material.BREWING_STAND, (String)Languages.MENU_RECIPE_CREATOR_ICON_CONFIRM.value(player))).setClickAction(event -> {
                StoredMenu creator = (StoredMenu)event.getClickedInventory().getHolder();
                ItemStack result = Objects.requireNonNull(creator).storedItems().get(24);
                ItemStack input = creator.storedItems().get(19);
                ItemStack ingredient = creator.storedItems().get(21);
                if (ItemHelper.isAir(result)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_RESULT);
                    return;
                }
                if (ItemHelper.isAir(ingredient) || ItemHelper.isAir(input)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                String resultName = ItemUtils.matchItemNameOrCreate(result, false);
                String inputName = ItemUtils.matchItemNameOrCreate(input, true);
                String ingredientName = ItemUtils.matchItemNameOrCreate(ingredient, true);
                BukkitConfigWrapper recipeConfig = this.createRecipeConfig(recipeName);
                recipeConfig.set("type", "potion");
                recipeConfig.set("source.input", inputName);
                recipeConfig.set("source.ingredient", ingredientName);
                recipeConfig.set("result", resultName);
                recipeConfig.saveConfig();
                recipeConfig.reloadConfig();
                this.regRecipeGroup(recipeConfig);
                event.getWhoClicked().closeInventory();
                this.sendSuccessMsg((HumanEntity)player, recipeName);
            }));
            return layoutMap;
        })));
    }
}

