/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.StoredMenu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.UnlockableRecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SmithingRecipeCreator
extends UnlockableRecipeCreator {
    private boolean copyNbt = false;

    public SmithingRecipeCreator(@NotNull Player player, @NotNull String recipeName) {
        super(player, RecipeType.SMITHING, recipeName);
        this.setDisplay(new MenuDisplay(this.title(), new MenuLayout(() -> Arrays.asList("####F####", "#***#%%%#", "#   A% %#", "#***#%%%#", "####B####"), () -> {
            HashMap<Character, Supplier<Icon>> layoutMap = new HashMap<Character, Supplier<Icon>>();
            layoutMap.put(Character.valueOf('#'), this::getFrameIcon);
            layoutMap.put(Character.valueOf('*'), () -> new Icon(new IconDisplay(Material.CYAN_STAINED_GLASS_PANE, (String)Languages.MENU_RECIPE_CREATOR_ICON_SMITHING_FRAME.value(player))));
            layoutMap.put(Character.valueOf('%'), this::getResultFrameIcon);
            layoutMap.put(Character.valueOf('F'), this::getUnlockIcon);
            layoutMap.put(Character.valueOf('B'), this::getCopyNbtIcon);
            layoutMap.put(Character.valueOf('A'), () -> new Icon(new IconDisplay(Material.SMITHING_TABLE, (String)Languages.MENU_RECIPE_CREATOR_ICON_CONFIRM.value(player))).setClickAction(event -> {
                StoredMenu creator = (StoredMenu)Objects.requireNonNull(event.getClickedInventory()).getHolder();
                ItemStack result = Objects.requireNonNull(creator).storedItems().get(24);
                if (ItemHelper.isAir(result)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_RESULT);
                    return;
                }
                String resultName = ItemUtils.matchItemNameOrCreate(result, false);
                ItemStack template = creator.storedItems().get(19);
                ItemStack base = creator.storedItems().get(20);
                ItemStack addition = creator.storedItems().get(21);
                String templateName = ItemUtils.matchItemNameOrCreate(template, true);
                if (ItemHelper.isAir(template)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                if (ItemHelper.isAir(base) || ItemHelper.isAir(addition)) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                String baseName = ItemUtils.matchItemNameOrCreate(base, true);
                String additionName = ItemUtils.matchItemNameOrCreate(addition, true);
                BukkitConfigWrapper recipeConfig = this.createRecipeConfig(recipeName);
                recipeConfig.set("result", resultName);
                recipeConfig.set("source.base", baseName);
                recipeConfig.set("source.addition", additionName);
                recipeConfig.set("type", "smithing");
                recipeConfig.set("source.type", "transform");
                recipeConfig.set("source.template", templateName);
                recipeConfig.set("unlock", this.unlock());
                recipeConfig.set("source.copy_nbt", this.copyNbt);
                recipeConfig.saveConfig();
                recipeConfig.reloadConfig();
                this.regRecipeGroup(recipeConfig);
                event.getWhoClicked().closeInventory();
                this.sendSuccessMsg(event.getWhoClicked(), recipeName);
            }));
            return layoutMap;
        })));
    }

    protected Icon getCopyNbtIcon() {
        Icon icon = new Icon(new IconDisplay(Material.NAME_TAG, ((String)Languages.MENU_RECIPE_CREATOR_ICON_SMITHING_COPY_NBT_TOGGLE.value(this.player)).replace("<enable>", String.valueOf(this.copyNbt)))).setClickAction(event -> this.toggleCopyNbt(event.getSlot(), (InventoryClickEvent)event));
        if (this.copyNbt) {
            ItemUtils.toggleItemGlowing(icon.display());
        }
        return icon;
    }

    protected void toggleCopyNbt(int slot, InventoryClickEvent event) {
        super.toggleIconGlowing(slot, event);
        this.copyNbt = !this.copyNbt;
        ItemStack display = event.getCurrentItem();
        ItemHelper.setDisplayName(display, ((String)Languages.MENU_RECIPE_CREATOR_ICON_SMITHING_COPY_NBT_TOGGLE.value(this.player)).replace("<enable>", String.valueOf(this.copyNbt)));
    }
}

