/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.MenuLayout;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.StoredMenu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.UnlockableRecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StoneCuttingRecipeCreator
extends UnlockableRecipeCreator {
    public StoneCuttingRecipeCreator(@NotNull Player player, @NotNull String recipeName) {
        super(player, RecipeType.STONE_CUTTING, recipeName);
        this.setDisplay(new MenuDisplay(this.title(), new MenuLayout(Arrays.asList("#########", "#       #", "####A####", "#       #", "#########"), () -> {
            HashMap<Character, Supplier<Icon>> layoutMap = new HashMap<Character, Supplier<Icon>>();
            layoutMap.put(Character.valueOf('#'), this::getFrameIcon);
            layoutMap.put(Character.valueOf('F'), this::getUnlockIcon);
            layoutMap.put(Character.valueOf('A'), () -> new Icon(new IconDisplay(Material.STONECUTTER, (String)Languages.MENU_RECIPE_CREATOR_ICON_CONFIRM.value(player))).setClickAction(event -> {
                int i;
                StoredMenu creator = (StoredMenu)event.getClickedInventory().getHolder();
                ArrayList<String> sourceList = new ArrayList<String>();
                ArrayList<String> resultList = new ArrayList<String>();
                for (i = 10; i < 17; ++i) {
                    ItemStack source = Objects.requireNonNull(creator).storedItems().get(i);
                    if (ItemHelper.isAir(source)) continue;
                    sourceList.add(ItemUtils.matchItemNameOrCreate(source, true));
                }
                for (i = 28; i < 35; ++i) {
                    ItemStack result = creator.storedItems().get(i);
                    if (ItemHelper.isAir(result)) continue;
                    resultList.add(ItemUtils.matchItemNameOrCreate(result, false));
                }
                if (sourceList.isEmpty()) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_SOURCE);
                    return;
                }
                if (resultList.isEmpty()) {
                    LangUtils.sendLang((CommandSender)event.getWhoClicked(), Languages.COMMAND_CREATE_NULL_RESULT);
                    return;
                }
                BukkitConfigWrapper recipeConfig = this.createRecipeConfig(recipeName);
                recipeConfig.set("multiple", true);
                recipeConfig.set("result", resultList);
                recipeConfig.set("type", "stone_cutting");
                recipeConfig.set("source", sourceList);
                recipeConfig.set("unlock", this.unlock());
                recipeConfig.saveConfig();
                recipeConfig.reloadConfig();
                this.regRecipeGroup(recipeConfig);
                event.getWhoClicked().closeInventory();
                this.sendSuccessMsg(event.getWhoClicked(), recipeName);
            }));
            return layoutMap;
        })));
    }
}

