/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.creator;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.creator.RecipeCreator;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.util.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class UnlockableRecipeCreator
extends RecipeCreator {
    private boolean unlock = (Boolean)PluginConfigs.DEFAULT_RECIPE_UNLOCK.value();

    public UnlockableRecipeCreator(@NotNull Player player, @NotNull RecipeType recipeType, @NotNull String recipeName) {
        super(player, recipeType, recipeName);
    }

    protected Icon getUnlockIcon() {
        Icon icon = new Icon(new IconDisplay(Material.KNOWLEDGE_BOOK, ((String)Languages.MENU_RECIPE_CREATOR_ICON_UNLOCK.value(this.player)).replace("<unlock>", String.valueOf(this.unlock)))).setClickAction(event -> this.toggleUnlockIcon(event.getSlot(), (InventoryClickEvent)event));
        if (this.unlock) {
            ItemUtils.toggleItemGlowing(icon.display());
        }
        return icon;
    }

    public boolean unlock() {
        return this.unlock;
    }

    public UnlockableRecipeCreator setUnlock(boolean unlock) {
        this.unlock = unlock;
        return this;
    }

    protected void toggleUnlockIcon(int slot, InventoryClickEvent event) {
        super.toggleIconGlowing(slot, event);
        this.unlock = !this.unlock;
        ItemStack display = event.getCurrentItem();
        ItemHelper.setDisplayName(display, ((String)Languages.MENU_RECIPE_CREATOR_ICON_UNLOCK.value(this.player)).replace("<unlock>", String.valueOf(this.unlock)));
    }
}

