/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.display;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitMsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.Menu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.InventoryViewHelper;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.custom.AnvilRecipe;
import com.github.yufiriamazenta.craftorithm.recipe.custom.PotionMixRecipe;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.jetbrains.annotations.NotNull;

public class RecipeDisplayMenu
extends Menu {
    private final Recipe recipe;
    private final InventoryType inventoryType;
    private final String invTitle;
    private final Menu parentMenu;

    public RecipeDisplayMenu(Player player, Recipe recipe, Menu parentMenu) {
        super(player);
        this.parentMenu = parentMenu;
        this.recipe = recipe;
        RecipeType recipeType = RecipeManager.INSTANCE.getRecipeType(this.recipe);
        block0 : switch (recipeType) {
            case SHAPED: {
                this.setShapedRecipeMenu();
                this.inventoryType = InventoryType.WORKBENCH;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_SHAPED.value(player);
                break;
            }
            case SHAPELESS: {
                this.setShapelessRecipeMenu();
                this.inventoryType = InventoryType.WORKBENCH;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_SHAPELESS.value(player);
                break;
            }
            case COOKING: 
            case RANDOM_COOKING: {
                this.setCookingRecipeMenu();
                Recipe recipe2 = recipe;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FurnaceRecipe.class, BlastingRecipe.class, SmokingRecipe.class}, (Object)recipe2, n)) {
                    case 0: {
                        FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe2;
                        this.inventoryType = InventoryType.FURNACE;
                        this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_FURNACE.value(player);
                        break block0;
                    }
                    case 1: {
                        BlastingRecipe blastingRecipe = (BlastingRecipe)recipe2;
                        this.inventoryType = InventoryType.BLAST_FURNACE;
                        this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_BLASTING.value(player);
                        break block0;
                    }
                    case 2: {
                        SmokingRecipe smokingRecipe = (SmokingRecipe)recipe2;
                        this.inventoryType = InventoryType.SMOKER;
                        this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_SMOKING.value(player);
                        break block0;
                    }
                }
                this.inventoryType = InventoryType.FURNACE;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_CAMPFIRE.value(player);
                break;
            }
            case SMITHING: {
                this.setSmithingRecipeMenu();
                this.inventoryType = InventoryType.SMITHING;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_SMITHING.value(player);
                break;
            }
            case STONE_CUTTING: {
                this.setStoneCuttingRecipeMenu();
                this.inventoryType = InventoryType.CHEST;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_STONE_CUTTING.value(player);
                break;
            }
            case POTION: {
                this.setPotionMixRecipeMenu();
                this.inventoryType = InventoryType.BREWING;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_POTION.value(player);
                break;
            }
            case ANVIL: {
                this.setAnvilRecipeMenu();
                this.inventoryType = InventoryType.ANVIL;
                this.invTitle = (String)Languages.MENU_RECIPE_DISPLAY_TITLE_ANVIL.value(player);
                break;
            }
            default: {
                this.invTitle = "Unknown Type";
                this.inventoryType = InventoryType.CHEST;
                this.slotMap.put(15, new Icon(recipe.getResult()));
            }
        }
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)this.inventoryType, (String)BukkitTextProcessor.color(this.invTitle));
        for (Integer slot : this.slotMap.keySet()) {
            inventory.setItem(slot.intValue(), ((Icon)this.slotMap.get(slot)).display());
        }
        return inventory;
    }

    @Override
    public Icon onClick(int slot, InventoryClickEvent event) {
        BukkitMsgSender.INSTANCE.debug(event.getClick().name());
        return super.onClick(slot, event);
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    public void setShapedRecipeMenu() {
        ShapedRecipe shapedRecipe = (ShapedRecipe)this.recipe;
        String[] shape = shapedRecipe.getShape();
        Map itemMap = shapedRecipe.getIngredientMap();
        int columnStart = 1;
        int line = 0;
        for (String shapeStr : shape) {
            for (int i = 0; i < shapeStr.length(); ++i) {
                char c = shapeStr.charAt(i);
                if (itemMap.containsKey(Character.valueOf(c))) {
                    ItemStack item = (ItemStack)itemMap.get(Character.valueOf(c));
                    item = item == null ? new ItemStack(Material.AIR) : item.clone();
                    this.slotMap.put(columnStart, new Icon(item));
                }
                ++columnStart;
            }
            columnStart = 1 + 3 * ++line;
        }
        this.slotMap.put(0, new Icon(this.recipe.getResult()));
    }

    private void setShapelessRecipeMenu() {
        ShapelessRecipe shapelessRecipe = (ShapelessRecipe)this.recipe;
        List ingredientList = shapelessRecipe.getIngredientList();
        int slot = 1;
        for (ItemStack item : ingredientList) {
            ItemStack display = item.clone();
            display.setAmount(1);
            this.slotMap.put(slot, new Icon(display));
            ++slot;
        }
        this.slotMap.put(0, new Icon(this.recipe.getResult()));
    }

    private void setCookingRecipeMenu() {
        CookingRecipe cookingRecipe = (CookingRecipe)this.recipe;
        this.slotMap.put(2, new Icon(this.recipe.getResult()));
        ItemStack input = cookingRecipe.getInput();
        input.setAmount(1);
        this.slotMap.put(0, new Icon(input));
        this.slotMap.put(1, new Icon(new ItemStack(Material.LAVA_BUCKET)));
    }

    private void setSmithingRecipeMenu() {
        SmithingRecipe smithingRecipe = (SmithingRecipe)this.recipe;
        this.slotMap.put(1, new Icon(smithingRecipe.getBase().getItemStack()));
        this.slotMap.put(2, new Icon(smithingRecipe.getAddition().getItemStack()));
        this.slotMap.put(3, new Icon(smithingRecipe.getResult()));
        if (this.recipe instanceof SmithingTransformRecipe) {
            this.slotMap.put(0, new Icon(((SmithingTransformRecipe)this.recipe).getTemplate().getItemStack()));
        } else if (this.recipe instanceof SmithingTrimRecipe) {
            this.slotMap.put(0, new Icon(((SmithingTrimRecipe)this.recipe).getTemplate().getItemStack()));
        }
    }

    private void setStoneCuttingRecipeMenu() {
        StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)this.recipe;
        ItemStack input = stonecuttingRecipe.getInput();
        input.setAmount(1);
        this.slotMap.put(11, new Icon(input));
        this.slotMap.put(15, new Icon(stonecuttingRecipe.getResult()));
    }

    private void setPotionMixRecipeMenu() {
        PotionMixRecipe potionMixRecipe = (PotionMixRecipe)this.recipe;
        ItemStack input = potionMixRecipe.input().getItemStack();
        ItemStack ingredient = potionMixRecipe.ingredient().getItemStack();
        ItemStack result = potionMixRecipe.getResult();
        this.slotMap.put(0, new Icon(input));
        this.slotMap.put(3, new Icon(ingredient));
        this.slotMap.put(2, new Icon(result));
    }

    private void setAnvilRecipeMenu() {
        AnvilRecipe anvilRecipe = (AnvilRecipe)this.recipe;
        ItemStack base = anvilRecipe.base();
        ItemStack addition = anvilRecipe.addition();
        ItemStack result = anvilRecipe.getResult();
        this.slotMap.put(0, new Icon(base));
        this.slotMap.put(1, new Icon(addition));
        this.slotMap.put(2, new Icon(result));
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        if (this.parentMenu != null) {
            CrypticLibBukkit.scheduler().sync(() -> {
                Object inventoryView = InventoryViewHelper.getInventoryView((InventoryEvent)event);
                InventoryType type = InventoryViewHelper.getInventoryType(inventoryView);
                List<InventoryType> typeWhenNotOpenInv = Arrays.asList(InventoryType.CRAFTING, InventoryType.CREATIVE);
                if (!typeWhenNotOpenInv.contains(type)) {
                    return;
                }
                this.parentMenu.openMenu();
            });
        }
    }
}

