/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.display;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.Menu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.menu.display.RecipeDisplayMenu;
import com.github.yufiriamazenta.craftorithm.menu.display.RecipeListMenu;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeGroup;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;

public class RecipeGroupListMenu
extends Menu {
    private int page;
    private int maxPage;
    private List<Map.Entry<String, ItemStack>> recipeGroupResultList = new CopyOnWriteArrayList<Map.Entry<String, ItemStack>>();

    public RecipeGroupListMenu(Player player) {
        super(player);
        this.refreshRecipes();
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        this.resetIcons();
        if (this.inventoryCache == null) {
            this.inventoryCache = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)BukkitTextProcessor.color((String)Languages.MENU_NEW_RECIPE_LIST_TITLE.value(this.player)));
        }
        this.refreshInventory();
        return this.inventoryCache;
    }

    public void nextPage() {
        this.setPage(Math.min(this.page + 1, Math.max(0, this.maxPage - 1))).resetIcons();
        this.refreshInventory();
    }

    public void previousPage() {
        this.setPage(Math.max(this.page - 1, 0)).resetIcons();
        this.refreshInventory();
    }

    public RecipeGroupListMenu refreshRecipes() {
        HashMap recipeResultMap = new HashMap();
        RecipeManager.INSTANCE.recipeMap().forEach((recipeType, recipeGroupMap) -> recipeGroupMap.forEach((groupName, recipeGroup) -> {
            if (recipeGroup == null || recipeGroup.isEmpty()) {
                return;
            }
            Recipe firstRecipe = RecipeManager.INSTANCE.getRecipe(recipeGroup.groupRecipeKeys().get(0));
            if (firstRecipe == null) {
                return;
            }
            recipeResultMap.put(groupName, firstRecipe.getResult());
        }));
        this.recipeGroupResultList = new CopyOnWriteArrayList(recipeResultMap.entrySet());
        this.page = 0;
        int recipeGroupNum = recipeResultMap.size();
        this.maxPage = recipeGroupNum % 45 == 0 ? recipeGroupNum / 45 : recipeGroupNum / 45 + 1;
        this.recipeGroupResultList.sort((o1, o2) -> {
            int sortId = RecipeManager.INSTANCE.getRecipeGroupSortId((String)o1.getKey());
            int sortId2 = RecipeManager.INSTANCE.getRecipeGroupSortId((String)o2.getKey());
            return Integer.compare(sortId, sortId2);
        });
        return this;
    }

    public RecipeGroupListMenu resetIcons() {
        this.slotMap.clear();
        int[] frameSlots = new int[]{45, 47, 48, 49, 50, 51, 53};
        Icon frameIcon = new Icon(new IconDisplay(Material.BLACK_STAINED_GLASS_PANE, BukkitTextProcessor.color((String)Languages.MENU_NEW_RECIPE_LIST_ICON_FRAME.value(this.player))));
        for (int frameSlot : frameSlots) {
            this.slotMap.put(frameSlot, frameIcon);
        }
        this.slotMap.put(46, new Icon(new IconDisplay(Material.PAPER, BukkitTextProcessor.color((String)Languages.MENU_NEW_RECIPE_LIST_ICON_PREVIOUS.value(this.player)))).setClickAction(event -> this.previousPage()));
        this.slotMap.put(52, new Icon(new IconDisplay(Material.PAPER, BukkitTextProcessor.color((String)Languages.MENU_NEW_RECIPE_LIST_ICON_NEXT.value(this.player)))).setClickAction(event -> this.nextPage()));
        int recipeSlot = this.page * 45;
        for (int invSlot = 0; invSlot < 45 && recipeSlot < this.recipeGroupResultList.size(); ++invSlot, ++recipeSlot) {
            this.slotMap.put(invSlot, this.wrapIcon(recipeSlot));
        }
        for (int i = 0; i < 45; ++i) {
            if (this.slotMap.containsKey(i)) continue;
            this.slotMap.put(i, new Icon(new ItemStack(Material.AIR)));
        }
        return this;
    }

    public RecipeGroupListMenu refreshInventory() {
        this.inventoryCache.clear();
        for (Integer slot : this.slotMap.keySet()) {
            this.inventoryCache.setItem(slot.intValue(), ((Icon)this.slotMap.get(slot)).display());
        }
        return this;
    }

    @NotNull
    private Icon wrapIcon(int recipeSlot) {
        ItemStack display = this.recipeGroupResultList.get(recipeSlot).getValue();
        String recipeGroupName = this.recipeGroupResultList.get(recipeSlot).getKey();
        Icon icon = new Icon(display).setClickAction(event -> {
            switch (event.getClick()) {
                case RIGHT: 
                case SHIFT_RIGHT: {
                    break;
                }
                default: {
                    RecipeGroup recipeGroup1 = RecipeManager.INSTANCE.getRecipeGroup(recipeGroupName);
                    if (recipeGroup1 == null) {
                        throw new IllegalArgumentException("Can not find recipe group " + recipeGroupName);
                    }
                    if (recipeGroup1.groupRecipeKeys().size() < 2) {
                        new RecipeDisplayMenu(this.player, RecipeManager.INSTANCE.getRecipe(recipeGroup1.groupRecipeKeys().get(0)), this).openMenu();
                        break;
                    }
                    new RecipeListMenu(this.player, recipeGroup1.groupRecipeKeys(), this).openMenu();
                }
            }
        });
        ItemHelper.setLore(icon.display(), (List)Languages.MENU_NEW_RECIPE_LIST_ICON_ELEMENTS_LORE.value(this.player));
        return icon;
    }

    public int page() {
        return this.page;
    }

    public RecipeGroupListMenu setPage(int page) {
        this.page = page;
        return this;
    }
}

