/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.menu.display;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.Icon;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.display.IconDisplay;
import com.github.yufiriamazenta.craftorithm.crypticlib.ui.menu.Menu;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.InventoryViewHelper;
import com.github.yufiriamazenta.craftorithm.menu.display.RecipeDisplayMenu;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.jetbrains.annotations.NotNull;

public class RecipeListMenu
extends Menu {
    private int page;
    private final int maxPage;
    private final List<Recipe> recipeList;
    private final Menu parentMenu;

    public RecipeListMenu(Player player, Collection<NamespacedKey> recipeKeys) {
        this(player, recipeKeys, null);
    }

    public RecipeListMenu(Player player, Collection<NamespacedKey> recipeKeys, Menu parentMenu) {
        super(player);
        this.parentMenu = parentMenu;
        this.recipeList = new ArrayList<Recipe>();
        for (NamespacedKey key : recipeKeys) {
            this.recipeList.add(RecipeManager.INSTANCE.getRecipe(key));
        }
        this.page = 0;
        this.recipeList.removeIf(recipe -> {
            if (recipe == null) {
                return true;
            }
            if (recipe instanceof SmithingTrimRecipe) {
                return true;
            }
            return recipe.getResult().getType().equals((Object)Material.AIR);
        });
        int recipeNum = this.recipeList.size();
        this.maxPage = recipeNum % 45 == 0 ? recipeNum / 45 : recipeNum / 45 + 1;
        this.recipeList.sort((recipe1, recipe2) -> {
            ItemStack result = recipe1.getResult();
            ItemStack result1 = recipe2.getResult();
            return Integer.compare(result.getType().ordinal(), result1.getType().ordinal());
        });
    }

    public void nextPage() {
        this.setPage(Math.min(this.page + 1, Math.max(0, this.maxPage - 1))).resetIcons();
        this.inventoryCache.clear();
        for (Integer slot : this.slotMap.keySet()) {
            this.inventoryCache.setItem(slot.intValue(), ((Icon)this.slotMap.get(slot)).display());
        }
    }

    public void previousPage() {
        this.setPage(Math.max(this.page - 1, 0)).resetIcons();
        this.inventoryCache.clear();
        for (Integer slot : this.slotMap.keySet()) {
            this.inventoryCache.setItem(slot.intValue(), ((Icon)this.slotMap.get(slot)).display());
        }
    }

    private void resetIcons() {
        int i;
        this.slotMap.clear();
        int[] frame = new int[]{45, 47, 48, 49, 50, 51, 53};
        Icon frameIcon = new Icon(new IconDisplay(Material.BLACK_STAINED_GLASS_PANE, BukkitTextProcessor.color((String)Languages.MENU_RECIPE_LIST_ICON_FRAME.value(this.player))));
        for (int i2 : frame) {
            this.slotMap.put(i2, frameIcon);
        }
        this.slotMap.put(46, new Icon(new IconDisplay(Material.PAPER, BukkitTextProcessor.color((String)Languages.MENU_RECIPE_LIST_ICON_PREVIOUS.value(this.player)))).setClickAction(event -> this.previousPage()));
        this.slotMap.put(52, new Icon(new IconDisplay(Material.PAPER, BukkitTextProcessor.color((String)Languages.MENU_RECIPE_LIST_ICON_NEXT.value(this.player)))).setClickAction(event -> this.nextPage()));
        int recipeSlot = this.page * 45;
        for (i = 0; i < 45 && recipeSlot < this.recipeList.size(); ++i, ++recipeSlot) {
            Recipe recipe = this.recipeList.get(recipeSlot);
            if (recipe == null) continue;
            ItemStack display = recipe.getResult();
            this.slotMap.put(i, new Icon(display).setClickAction(event -> new RecipeDisplayMenu(this.player, recipe, this).openMenu()));
        }
        for (i = 0; i < 45; ++i) {
            if (this.slotMap.containsKey(i)) continue;
            this.slotMap.put(i, new Icon(new ItemStack(Material.AIR)));
        }
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        if (this.parentMenu != null) {
            CrypticLibBukkit.scheduler().sync(() -> {
                Object inventoryView = InventoryViewHelper.getInventoryView((InventoryEvent)event);
                InventoryType type = InventoryViewHelper.getInventoryType(inventoryView);
                List<InventoryType> typeWhenNotOpenInv = Arrays.asList(InventoryType.CRAFTING, InventoryType.CREATIVE);
                if (!typeWhenNotOpenInv.contains(type)) {
                    return;
                }
                this.parentMenu.openMenu();
            });
        }
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        this.resetIcons();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)BukkitTextProcessor.color((String)Languages.MENU_RECIPE_LIST_TITLE.value(this.player)));
        for (Integer slot : this.slotMap.keySet()) {
            inventory.setItem(slot.intValue(), ((Icon)this.slotMap.get(slot)).display());
        }
        return inventory;
    }

    public int page() {
        return this.page;
    }

    public RecipeListMenu setPage(int page) {
        this.page = page;
        return this;
    }
}

