/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.exception.UnsupportedVersionException;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.registry.RecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.AnvilRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.CookingRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.PotionMixRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.RandomCookingRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.ShapedRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.ShapelessRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.SmithingRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.StoneCuttingRecipeRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.bukkit.plugin.Plugin;

public class RecipeFactory {
    private static final Map<RecipeType, BiFunction<YamlConfiguration, String, List<RecipeRegistry>>> recipeRegistryProviderMap = new HashMap<RecipeType, BiFunction<YamlConfiguration, String, List<RecipeRegistry>>>();
    private static final Map<RecipeType, BiFunction<YamlConfiguration, String, List<RecipeRegistry>>> multipleRecipeRegistryProviderMap = new HashMap<RecipeType, BiFunction<YamlConfiguration, String, List<RecipeRegistry>>>();

    public static List<RecipeRegistry> newRecipeRegistry(YamlConfiguration config, String key) {
        key = key.toLowerCase(Locale.ROOT);
        String recipeTypeStr = config.getString("type", "shaped");
        RecipeType recipeType = RecipeType.valueOf(recipeTypeStr.toUpperCase(Locale.ROOT));
        boolean multiple = config.getBoolean("multiple", false);
        if (multiple) {
            return multipleRecipeRegistryProviderMap.getOrDefault((Object)recipeType, (c, k) -> {
                throw new UnsupportedVersionException("Can not create " + recipeType.name().toLowerCase() + " recipe registry");
            }).apply(config, key);
        }
        return recipeRegistryProviderMap.getOrDefault((Object)recipeType, (c, k) -> {
            throw new UnsupportedVersionException("Can not create " + recipeType.name().toLowerCase() + " recipe registry");
        }).apply(config, key);
    }

    public static List<RecipeRegistry> newShapedRecipe(YamlConfiguration config, String key) {
        Map<Character, RecipeChoice> recipeChoiceMap = RecipeFactory.getShapedRecipeChoiceMap(config.getConfigurationSection("source"));
        ItemStack result = RecipeFactory.getResultItem(config);
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        List shapeStrList = config.getStringList("shape");
        CraftingBookCategory category = null;
        if (config.contains("category")) {
            String categoryStr = config.getString("category").toUpperCase();
            category = CraftingBookCategory.valueOf((String)categoryStr);
        }
        if (shapeStrList.size() > 3) {
            shapeStrList = shapeStrList.subList(0, 3);
        }
        String[] shape = new String[shapeStrList.size()];
        shape = shapeStrList.toArray(shape);
        ShapedRecipeRegistry recipeRegistry = new ShapedRecipeRegistry(key, namespacedKey, result).setShape(shape).setRecipeChoiceMap(recipeChoiceMap).setCraftingBookCategory(category);
        return Collections.singletonList(recipeRegistry);
    }

    public static List<RecipeRegistry> newMultipleShapedRecipe(YamlConfiguration config, String key) {
        Map<Character, RecipeChoice> recipeChoiceMap = RecipeFactory.getShapedRecipeChoiceMap(config.getConfigurationSection("source"));
        ItemStack result = RecipeFactory.getResultItem(config);
        List shapeList = config.getList("shape", new ArrayList());
        CraftingBookCategory category = null;
        if (config.contains("category")) {
            String categoryStr = config.getString("category").toUpperCase();
            category = CraftingBookCategory.valueOf((String)categoryStr);
        }
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        for (int i = 0; i < shapeList.size(); ++i) {
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            List shapeStrList = (List)shapeList.get(i);
            if (shapeStrList.size() > 3) {
                shapeStrList = shapeStrList.subList(0, 3);
            }
            String[] shape = new String[shapeStrList.size()];
            shape = shapeStrList.toArray(shape);
            recipeRegistries.add(new ShapedRecipeRegistry(key, namespacedKey, result).setShape(shape).setRecipeChoiceMap(recipeChoiceMap).setCraftingBookCategory(category));
        }
        return recipeRegistries;
    }

    public static List<RecipeRegistry> newShapelessRecipe(YamlConfiguration config, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        ItemStack result = RecipeFactory.getResultItem(config);
        List itemStrList = config.getStringList("source");
        ArrayList<RecipeChoice> recipeChoiceList = new ArrayList<RecipeChoice>();
        for (String itemStr : itemStrList) {
            recipeChoiceList.add(RecipeFactory.getRecipeChoice(itemStr));
        }
        CraftingBookCategory category = null;
        if (config.contains("category")) {
            String categoryStr = config.getString("category").toUpperCase();
            category = CraftingBookCategory.valueOf((String)categoryStr);
        }
        ShapelessRecipeRegistry recipeRegistry = new ShapelessRecipeRegistry(key, namespacedKey, result).setChoiceList(recipeChoiceList).setCraftingBookCategory(category);
        return Collections.singletonList(recipeRegistry);
    }

    public static List<RecipeRegistry> newMultipleShapelessRecipe(YamlConfiguration config, String key) {
        ItemStack result = RecipeFactory.getResultItem(config);
        List itemsList = config.getList("source", new ArrayList());
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        CraftingBookCategory category = null;
        if (config.contains("category")) {
            String categoryStr = config.getString("category").toUpperCase();
            category = CraftingBookCategory.valueOf((String)categoryStr);
        }
        for (int i = 0; i < itemsList.size(); ++i) {
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            List itemStrList = (List)itemsList.get(i);
            ArrayList<RecipeChoice> choiceList = new ArrayList<RecipeChoice>();
            for (String itemStr : itemStrList) {
                choiceList.add(RecipeFactory.getRecipeChoice(itemStr));
            }
            recipeRegistries.add(new ShapelessRecipeRegistry(key, namespacedKey, result).setChoiceList(choiceList).setCraftingBookCategory(category));
        }
        return recipeRegistries;
    }

    public static List<RecipeRegistry> newCookingRecipe(YamlConfiguration config, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        ItemStack result = RecipeFactory.getResultItem(config);
        String choiceStr = config.getString("source.item", "");
        String cookingBlock = config.getString("source.block", "furnace");
        RecipeChoice source = RecipeFactory.getRecipeChoice(choiceStr);
        float exp = (float)config.getDouble("exp", 0.0);
        int time = config.getInt("time", 200);
        CookingBookCategory category = null;
        if (config.contains("category")) {
            String categoryStr = config.getString("category").toUpperCase();
            category = CookingBookCategory.valueOf((String)categoryStr);
        }
        CookingRecipeRegistry recipeRegistry = new CookingRecipeRegistry(key, namespacedKey, result).setCookingBlock(cookingBlock).setSource(source).setExp(exp).setTime(time).setCookingBookCategory(category);
        return Collections.singletonList(recipeRegistry);
    }

    public static List<RecipeRegistry> newMultipleCookingRecipe(YamlConfiguration config, String key) {
        ItemStack result = RecipeFactory.getResultItem(config);
        float globalExp = (float)config.getDouble("exp", 0.0);
        int globalTime = config.getInt("time", 200);
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        CookingBookCategory category = null;
        if (config.contains("category")) {
            String categoryStr = config.getString("category").toUpperCase();
            category = CookingBookCategory.valueOf((String)categoryStr);
        }
        List sourceList = config.getMapList("source");
        for (int i = 0; i < sourceList.size(); ++i) {
            Map map = (Map)sourceList.get(i);
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            RecipeChoice source = RecipeFactory.getRecipeChoice((String)map.get("item"));
            String cookingBlock = (String)map.get("block");
            float exp = map.containsKey("exp") ? Float.parseFloat(String.valueOf(map.get("exp"))) : globalExp;
            int time = map.containsKey("time") ? (Integer)map.get("time") : globalTime;
            recipeRegistries.add(new CookingRecipeRegistry(key, namespacedKey, result).setCookingBlock(cookingBlock).setSource(source).setExp(exp).setTime(time).setCookingBookCategory(category));
        }
        return recipeRegistries;
    }

    private static List<RecipeRegistry> newRandomCookingRecipe(YamlConfiguration config, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        ItemStack result = RecipeFactory.getResultItem(config);
        String choiceStr = config.getString("source.item", "");
        String cookingBlock = config.getString("source.block", "furnace");
        RecipeChoice source = RecipeFactory.getRecipeChoice(choiceStr);
        float exp = (float)config.getDouble("exp", 0.0);
        int time = config.getInt("time", 200);
        CookingRecipeRegistry recipeRegistry = new RandomCookingRecipeRegistry(key, namespacedKey, result).setCookingBlock(cookingBlock).setSource(source).setExp(exp).setTime(time);
        return Collections.singletonList(recipeRegistry);
    }

    private static List<RecipeRegistry> newMultipleRandomCookingRecipe(YamlConfiguration config, String key) {
        ItemStack result = RecipeFactory.getResultItem(config);
        float globalExp = (float)config.getDouble("exp", 0.0);
        int globalTime = config.getInt("time", 200);
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        List sourceList = config.getMapList("source");
        for (int i = 0; i < sourceList.size(); ++i) {
            Map map = (Map)sourceList.get(i);
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            RecipeChoice source = RecipeFactory.getRecipeChoice((String)map.get("item"));
            String cookingBlock = (String)map.get("block");
            float exp = map.containsKey("exp") ? Float.parseFloat(String.valueOf(map.get("exp"))) : globalExp;
            int time = map.containsKey("time") ? (Integer)map.get("time") : globalTime;
            recipeRegistries.add(new RandomCookingRecipeRegistry(key, namespacedKey, result).setCookingBlock(cookingBlock).setSource(source).setExp(exp).setTime(time));
        }
        return recipeRegistries;
    }

    public static List<RecipeRegistry> newSmithingRecipe(YamlConfiguration config, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        ItemStack result = RecipeFactory.getResultItem(config);
        RecipeChoice base = RecipeFactory.getRecipeChoice(config.getString("source.base", ""));
        RecipeChoice addition = RecipeFactory.getRecipeChoice(config.getString("source.addition", ""));
        boolean copyNbt = config.getBoolean("source.copy_nbt", false);
        boolean copyEnchantments = config.getBoolean("source.copy_enchantments", true);
        RecipeChoice template = RecipeFactory.getRecipeChoice(config.getString("source.template", ""));
        SmithingRecipeRegistry.SmithingType type = SmithingRecipeRegistry.SmithingType.valueOf(config.getString("source.type", "default").toUpperCase());
        SmithingRecipeRegistry recipeRegistry = new SmithingRecipeRegistry(key, namespacedKey, result).setSmithingType(type).setTemplate(template).setBase(base).setAddition(addition).setCopyNbt(copyNbt).setCopyEnchantments(copyEnchantments);
        return Collections.singletonList(recipeRegistry);
    }

    public static List<RecipeRegistry> newMultipleSmithingRecipe(YamlConfiguration config, String key) {
        ItemStack result = RecipeFactory.getResultItem(config);
        List sourceList = config.getMapList("source");
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        for (int i = 0; i < sourceList.size(); ++i) {
            Map map = (Map)sourceList.get(i);
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            RecipeChoice base = RecipeFactory.getRecipeChoice((String)map.get("base"));
            RecipeChoice addition = RecipeFactory.getRecipeChoice((String)map.get("addition"));
            boolean copyNbt = map.containsKey("copy_nbt") ? (Boolean)map.get("copy_nbt") : false;
            boolean copyEnchantments = map.containsKey("copy_enchantments") ? (Boolean)map.get("copy_enchantments") : true;
            String typeStr = (String)map.get("type");
            if (typeStr == null) {
                typeStr = "DEFAULT";
            }
            RecipeChoice template = RecipeFactory.getRecipeChoice((String)map.get("template"));
            SmithingRecipeRegistry.SmithingType type = SmithingRecipeRegistry.SmithingType.valueOf(typeStr.toUpperCase());
            recipeRegistries.add(new SmithingRecipeRegistry(key, namespacedKey, result).setSmithingType(type).setTemplate(template).setBase(base).setAddition(addition).setCopyNbt(copyNbt).setCopyEnchantments(copyEnchantments));
        }
        return recipeRegistries;
    }

    public static List<RecipeRegistry> newStoneCuttingRecipe(YamlConfiguration config, String key) {
        RecipeChoice choice = RecipeFactory.getRecipeChoice(config.getString("source", ""));
        if (config.isList("result")) {
            List resultList = config.getStringList("result");
            ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
            for (int i = 0; i < resultList.size(); ++i) {
                ItemStack result = ItemManager.INSTANCE.matchItem((String)resultList.get(i));
                String fullKey = key + "." + i;
                NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
                recipeRegistries.add(new StoneCuttingRecipeRegistry(key, namespacedKey, result).setSource(choice));
            }
            return recipeRegistries;
        }
        ItemStack result = RecipeFactory.getResultItem(config);
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        return Collections.singletonList(new StoneCuttingRecipeRegistry(key, namespacedKey, result).setSource(choice));
    }

    public static List<RecipeRegistry> newMultipleStoneCuttingRecipe(YamlConfiguration config, String key) {
        if (config.isList("result")) {
            List resultList = config.getStringList("result");
            List sourceList = config.getStringList("source");
            ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
            for (int i = 0; i < resultList.size(); ++i) {
                ItemStack result = ItemManager.INSTANCE.matchItem((String)resultList.get(i));
                for (int j = 0; j < sourceList.size(); ++j) {
                    String fullKey = String.format(key + ".%d.%d", i, j);
                    NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
                    RecipeChoice source = RecipeFactory.getRecipeChoice((String)sourceList.get(j));
                    recipeRegistries.add(new StoneCuttingRecipeRegistry(key, namespacedKey, result).setSource(source));
                }
            }
            return recipeRegistries;
        }
        ItemStack result = RecipeFactory.getResultItem(config);
        List sourceList = config.getStringList("source");
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        for (int i = 0; i < sourceList.size(); ++i) {
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            RecipeChoice source = RecipeFactory.getRecipeChoice((String)sourceList.get(i));
            recipeRegistries.add(new StoneCuttingRecipeRegistry(key, namespacedKey, result).setSource(source));
        }
        return recipeRegistries;
    }

    public static List<RecipeRegistry> newPotionMixRecipe(YamlConfiguration config, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        ItemStack result = RecipeFactory.getResultItem(config);
        RecipeChoice input = RecipeFactory.getRecipeChoice(config.getString("source.input", ""));
        RecipeChoice ingredient = RecipeFactory.getRecipeChoice(config.getString("source.ingredient", ""));
        return Collections.singletonList(new PotionMixRecipeRegistry(key, namespacedKey, result).setInput(input).setIngredient(ingredient));
    }

    public static List<RecipeRegistry> newMultiplePotionMixRecipe(YamlConfiguration config, String key) {
        ItemStack result = RecipeFactory.getResultItem(config);
        List sourceList = config.getMapList("source");
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        for (int i = 0; i < sourceList.size(); ++i) {
            Map map = (Map)sourceList.get(i);
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            RecipeChoice input = RecipeFactory.getRecipeChoice((String)map.get("input"));
            RecipeChoice ingredient = RecipeFactory.getRecipeChoice((String)map.get("ingredient"));
            recipeRegistries.add(new PotionMixRecipeRegistry(key, namespacedKey, result).setInput(input).setIngredient(ingredient));
        }
        return recipeRegistries;
    }

    public static List<RecipeRegistry> newAnvilRecipe(YamlConfiguration config, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), key);
        ItemStack result = RecipeFactory.getResultItem(config);
        ItemStack base = ItemManager.INSTANCE.matchItem(config.getString("source.base", ""));
        ItemStack addition = ItemManager.INSTANCE.matchItem(config.getString("source.addition", ""));
        int costLevel = config.getInt("source.cost_level", 0);
        boolean copyNbt = config.getBoolean("source.copy_nbt", false);
        boolean copyEnchantments = config.getBoolean("source.copy_enchantments", true);
        AnvilRecipeRegistry recipeRegistry = new AnvilRecipeRegistry(key, namespacedKey, result).setBase(base).setAddition(addition).setCopyNbt(copyNbt).setCopyEnchantments(copyEnchantments).setCostLevel(costLevel);
        return Collections.singletonList(recipeRegistry);
    }

    public static List<RecipeRegistry> newMultipleAnvilRecipe(YamlConfiguration config, String key) {
        ItemStack result = RecipeFactory.getResultItem(config);
        List sourceList = config.getMapList("source");
        ArrayList<RecipeRegistry> recipeRegistries = new ArrayList<RecipeRegistry>();
        for (int i = 0; i < sourceList.size(); ++i) {
            Map map = (Map)sourceList.get(i);
            String fullKey = key + "." + i;
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)Craftorithm.instance(), fullKey);
            ItemStack base = ItemManager.INSTANCE.matchItem((String)map.get("base"));
            ItemStack addition = ItemManager.INSTANCE.matchItem((String)map.get("addition"));
            int costLevel = map.containsKey("cost_level") ? (Integer)map.get("cost_level") : 0;
            boolean copyNbt = map.containsKey("copy_nbt") ? (Boolean)map.get("copy_nbt") : false;
            boolean copyEnchantments = map.containsKey("copy_enchantments") ? (Boolean)map.get("copy_enchantments") : true;
            recipeRegistries.add(new AnvilRecipeRegistry(key, namespacedKey, result).setBase(base).setAddition(addition).setCopyNbt(copyNbt).setCopyEnchantments(copyEnchantments).setCostLevel(costLevel));
        }
        return recipeRegistries;
    }

    private static Map<Character, RecipeChoice> getShapedRecipeChoiceMap(ConfigurationSection section) {
        HashMap<Character, RecipeChoice> recipeChoiceMap = new HashMap<Character, RecipeChoice>();
        if (section == null) {
            return recipeChoiceMap;
        }
        for (String key : section.getKeys(false)) {
            char keyWord = key.toCharArray()[0];
            String itemStr = section.getString(key, "");
            if (itemStr.isEmpty()) {
                throw new IllegalArgumentException("Empty recipe ingredient: " + key);
            }
            recipeChoiceMap.put(Character.valueOf(keyWord), RecipeFactory.getRecipeChoice(itemStr));
        }
        return recipeChoiceMap;
    }

    private static ItemStack getResultItem(YamlConfiguration config) {
        String resultStr;
        if (config.getString("type", "shaped").equals("random_cooking")) {
            String tmpStr = (String)config.getStringList("result").get(0);
            resultStr = tmpStr = tmpStr.substring(0, tmpStr.lastIndexOf(" "));
        } else {
            resultStr = config.getString("result", "");
        }
        if (resultStr.isEmpty()) {
            return null;
        }
        return ItemManager.INSTANCE.matchItem(resultStr);
    }

    public static RecipeChoice getRecipeChoice(String itemStr) {
        if (!itemStr.contains(":")) {
            Material material = Material.matchMaterial((String)itemStr);
            if (material == null) {
                throw new IllegalArgumentException(itemStr + " is a not exist item type");
            }
            return new RecipeChoice.MaterialChoice(material);
        }
        int index = itemStr.indexOf(":");
        String namespace = itemStr.substring(0, index);
        switch (namespace = namespace.toLowerCase()) {
            case "minecraft": {
                Material material = Material.matchMaterial((String)itemStr);
                if (material == null) {
                    throw new IllegalArgumentException(itemStr + " is a not exist item type");
                }
                return new RecipeChoice.MaterialChoice(material);
            }
            case "tag": {
                Tag materialTag;
                String tagStr = itemStr.substring(4).toUpperCase(Locale.ROOT);
                try {
                    Field field = Tag.class.getField(tagStr);
                    materialTag = (Tag)field.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                return new RecipeChoice.MaterialChoice(materialTag);
            }
        }
        ItemStack item = ItemManager.INSTANCE.matchItem(itemStr).clone();
        item.setAmount(1);
        return new RecipeChoice.ExactChoice(item);
    }

    static {
        recipeRegistryProviderMap.put(RecipeType.SHAPED, RecipeFactory::newShapedRecipe);
        recipeRegistryProviderMap.put(RecipeType.SHAPELESS, RecipeFactory::newShapelessRecipe);
        multipleRecipeRegistryProviderMap.put(RecipeType.SHAPED, RecipeFactory::newMultipleShapedRecipe);
        multipleRecipeRegistryProviderMap.put(RecipeType.SHAPELESS, RecipeFactory::newMultipleShapelessRecipe);
        recipeRegistryProviderMap.put(RecipeType.COOKING, RecipeFactory::newCookingRecipe);
        multipleRecipeRegistryProviderMap.put(RecipeType.COOKING, RecipeFactory::newMultipleCookingRecipe);
        recipeRegistryProviderMap.put(RecipeType.STONE_CUTTING, RecipeFactory::newStoneCuttingRecipe);
        multipleRecipeRegistryProviderMap.put(RecipeType.STONE_CUTTING, RecipeFactory::newMultipleStoneCuttingRecipe);
        recipeRegistryProviderMap.put(RecipeType.SMITHING, RecipeFactory::newSmithingRecipe);
        multipleRecipeRegistryProviderMap.put(RecipeType.SMITHING, RecipeFactory::newMultipleSmithingRecipe);
        recipeRegistryProviderMap.put(RecipeType.RANDOM_COOKING, RecipeFactory::newRandomCookingRecipe);
        multipleRecipeRegistryProviderMap.put(RecipeType.RANDOM_COOKING, RecipeFactory::newMultipleRandomCookingRecipe);
        if (RecipeManager.INSTANCE.supportPotionMix()) {
            recipeRegistryProviderMap.put(RecipeType.POTION, RecipeFactory::newPotionMixRecipe);
            multipleRecipeRegistryProviderMap.put(RecipeType.POTION, RecipeFactory::newMultiplePotionMixRecipe);
        }
        if (((Boolean)PluginConfigs.ENABLE_ANVIL_RECIPE.value()).booleanValue()) {
            recipeRegistryProviderMap.put(RecipeType.ANVIL, RecipeFactory::newAnvilRecipe);
            multipleRecipeRegistryProviderMap.put(RecipeType.ANVIL, RecipeFactory::newMultipleAnvilRecipe);
        }
    }
}

