/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe;

import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class RecipeGroup {
    private String groupName;
    private List<NamespacedKey> groupRecipeKeys = new CopyOnWriteArrayList<NamespacedKey>();
    private final RecipeType recipeType;
    private BukkitConfigWrapper recipeGroupConfig;
    private int sortId;
    private boolean unlock;

    public RecipeGroup(@NotNull String groupName, @NotNull RecipeType recipeType, @NotNull BukkitConfigWrapper recipeGroupConfig) {
        this(groupName, new ArrayList<NamespacedKey>(), recipeType, recipeGroupConfig);
    }

    public RecipeGroup(@NotNull String groupName, @NotNull List<NamespacedKey> groupRecipeKeys, @NotNull RecipeType recipeType, @NotNull BukkitConfigWrapper recipeGroupConfig) {
        this.groupName = groupName;
        this.groupRecipeKeys.addAll(groupRecipeKeys);
        this.recipeType = recipeType;
        this.recipeGroupConfig = recipeGroupConfig;
        this.sortId = ((YamlConfiguration)recipeGroupConfig.config()).getInt("sort_id", 0);
        this.unlock = ((YamlConfiguration)recipeGroupConfig.config()).getBoolean("unlock", ((Boolean)PluginConfigs.DEFAULT_RECIPE_UNLOCK.value()).booleanValue());
    }

    public String groupName() {
        return this.groupName;
    }

    public RecipeGroup setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public List<NamespacedKey> groupRecipeKeys() {
        return this.groupRecipeKeys;
    }

    public RecipeGroup setGroupRecipeKeys(List<NamespacedKey> groupRecipeKeys) {
        this.groupRecipeKeys = groupRecipeKeys;
        return this;
    }

    public boolean contains(NamespacedKey namespacedKey) {
        return this.groupRecipeKeys.contains(namespacedKey);
    }

    public RecipeGroup addRecipeKey(NamespacedKey namespacedKey) {
        if (this.groupRecipeKeys.contains(namespacedKey)) {
            return this;
        }
        this.groupRecipeKeys.add(namespacedKey);
        return this;
    }

    public boolean isEmpty() {
        return this.groupRecipeKeys.isEmpty();
    }

    public RecipeType recipeType() {
        return this.recipeType;
    }

    public int sortId() {
        return this.sortId;
    }

    public RecipeGroup setSortId(int sortId) {
        this.sortId = sortId;
        return this;
    }

    public boolean unlock() {
        return this.unlock;
    }

    public RecipeGroup setUnlock(boolean unlock) {
        this.unlock = unlock;
        return this;
    }

    @NotNull
    public BukkitConfigWrapper recipeGroupConfig() {
        return this.recipeGroupConfig;
    }

    public RecipeGroup setRecipeGroupConfig(BukkitConfigWrapper recipeGroupConfig) {
        this.recipeGroupConfig = recipeGroupConfig;
        return this;
    }
}

