/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitMsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.lang.entry.StringLangEntry;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import com.github.yufiriamazenta.craftorithm.exception.UnsupportedVersionException;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeFactory;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeGroup;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.custom.AnvilRecipe;
import com.github.yufiriamazenta.craftorithm.recipe.custom.CustomRecipe;
import com.github.yufiriamazenta.craftorithm.recipe.custom.PotionMixRecipe;
import com.github.yufiriamazenta.craftorithm.recipe.registry.RecipeRegistry;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.SmithingRecipeRegistry;
import com.github.yufiriamazenta.craftorithm.util.CollectionsUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import com.github.yufiriamazenta.craftorithm.util.RecipeUtils;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ENABLE), @TaskRule(lifeCycle=LifeCycle.RELOAD, priority=2)})
public enum RecipeManager implements BukkitLifeCycleTask
{
    INSTANCE;

    public final File RECIPE_FILE_FOLDER = new File(Craftorithm.instance().getDataFolder().getPath(), "recipes");
    private final BukkitConfigWrapper removedRecipesConfigWrapper = new BukkitConfigWrapper((Plugin)Craftorithm.instance(), "removed_recipes.yml");
    public final String PLUGIN_RECIPE_NAMESPACE = "craftorithm";
    private final Map<NamespacedKey, RecipeRegistry> recipeRegistryMap = new ConcurrentHashMap<NamespacedKey, RecipeRegistry>();
    private final Map<RecipeType, Map<String, RecipeGroup>> pluginRecipeMap = new ConcurrentHashMap<RecipeType, Map<String, RecipeGroup>>();
    private final Map<RecipeType, Consumer<Recipe>> recipeRegisterMap = new ConcurrentHashMap<RecipeType, Consumer<Recipe>>();
    private final Map<RecipeType, Consumer<List<NamespacedKey>>> recipeRemoverMap = new ConcurrentHashMap<RecipeType, Consumer<List<NamespacedKey>>>();
    private final Map<NamespacedKey, Boolean> recipeUnlockMap = new ConcurrentHashMap<NamespacedKey, Boolean>();
    private final List<Recipe> removeRecipeRecycleBin;
    private final Map<NamespacedKey, Recipe> serverRecipesCache;
    private final Map<NamespacedKey, PotionMixRecipe> potionMixRecipeMap = new ConcurrentHashMap<NamespacedKey, PotionMixRecipe>();
    private final Map<NamespacedKey, AnvilRecipe> anvilRecipeMap = new ConcurrentHashMap<NamespacedKey, AnvilRecipe>();
    public static final List<RecipeType> UNLOCKABLE_RECIPE_TYPE;
    private Boolean supportPotionMix;

    private RecipeManager() {
        this.removeRecipeRecycleBin = new CopyOnWriteArrayList<Recipe>();
        this.serverRecipesCache = new ConcurrentHashMap<NamespacedKey, Recipe>();
    }

    public void reloadRecipeManager() {
        this.resetRecipes();
        this.loadRecipeGroups();
        this.loadRecipes();
        this.loadServerRecipeCache();
        this.reloadRemovedRecipes();
    }

    private void loadRecipes() {
        for (Map.Entry<RecipeType, Map<String, RecipeGroup>> pluginRecipeMapEntry : this.pluginRecipeMap.entrySet()) {
            Map<String, RecipeGroup> recipeGroupMap = pluginRecipeMapEntry.getValue();
            recipeGroupMap.forEach((recipeGroupName, recipeGroup) -> this.loadRecipeGroup((RecipeGroup)recipeGroup));
        }
        if (CrypticLibBukkit.platform().isPaper() && MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_20_1)) {
            Bukkit.updateRecipes();
        }
    }

    public void loadRecipeGroup(RecipeGroup recipeGroup) {
        try {
            YamlConfiguration config = (YamlConfiguration)recipeGroup.recipeGroupConfig().config();
            if (!this.hasCraftorithmRecipe(recipeGroup.groupName())) {
                this.addRecipeGroup(recipeGroup);
            }
            for (RecipeRegistry recipeRegistry : RecipeFactory.newRecipeRegistry(config, recipeGroup.groupName())) {
                recipeRegistry.register();
                this.recipeRegistryMap.put(recipeRegistry.namespacedKey(), recipeRegistry);
                if (!UNLOCKABLE_RECIPE_TYPE.contains((Object)recipeGroup.recipeType())) continue;
                this.recipeUnlockMap.put(recipeRegistry.namespacedKey(), recipeGroup.unlock());
            }
        }
        catch (Throwable throwable) {
            LangUtils.info(Languages.LOAD_RECIPE_LOAD_EXCEPTION, CollectionsUtils.newStringHashMap("<recipe_name>", recipeGroup.groupName()));
            throwable.printStackTrace();
        }
    }

    public void addRecipeGroup(RecipeGroup recipeGroup) {
        RecipeType recipeType = recipeGroup.recipeType();
        if (this.pluginRecipeMap.containsKey((Object)recipeType)) {
            Map<String, RecipeGroup> recipeGroupMap = this.pluginRecipeMap.get((Object)recipeType);
            recipeGroupMap.put(recipeGroup.groupName(), recipeGroup);
        } else {
            ConcurrentHashMap<String, RecipeGroup> recipeGroupMap = new ConcurrentHashMap<String, RecipeGroup>();
            recipeGroupMap.put(recipeGroup.groupName(), recipeGroup);
            this.pluginRecipeMap.put(recipeType, recipeGroupMap);
        }
    }

    private void loadRecipeGroups() {
        boolean mkdirResult;
        this.pluginRecipeMap.clear();
        if (!this.RECIPE_FILE_FOLDER.exists() && !(mkdirResult = this.RECIPE_FILE_FOLDER.mkdir())) {
            return;
        }
        List<File> allFiles = IOHelper.allYamlFiles(this.RECIPE_FILE_FOLDER);
        if (allFiles.isEmpty()) {
            this.saveDefConfigFile(allFiles);
        }
        for (File file : allFiles) {
            try {
                String recipeGroupName = file.getPath().substring(this.RECIPE_FILE_FOLDER.getPath().length() + 1);
                recipeGroupName = recipeGroupName.replace("\\", "/");
                int lastDotIndex = recipeGroupName.lastIndexOf(".");
                recipeGroupName = recipeGroupName.substring(0, lastDotIndex).toLowerCase();
                BukkitConfigWrapper recipeGroupConfigWrapper = new BukkitConfigWrapper(file);
                String typeStr = ((YamlConfiguration)recipeGroupConfigWrapper.config()).getString("type");
                RecipeType recipeType = RecipeType.valueOf(typeStr.toUpperCase());
                RecipeGroup recipeGroup = new RecipeGroup(recipeGroupName, recipeType, recipeGroupConfigWrapper);
                this.addRecipeGroup(recipeGroup);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void regRecipe(String recipeGroupName, Recipe recipe, RecipeType recipeType) {
        Map<String, RecipeGroup> recipeGroupMap;
        if (!this.pluginRecipeMap.containsKey((Object)recipeType)) {
            this.pluginRecipeMap.put(recipeType, new ConcurrentHashMap());
        }
        if (!(recipeGroupMap = this.pluginRecipeMap.get((Object)recipeType)).containsKey(recipeGroupName)) {
            throw new IllegalArgumentException("Can not find recipe group " + recipeGroupName + ", use addRecipeGroup() method to add recipe group.");
        }
        RecipeGroup recipeGroup = recipeGroupMap.get(recipeGroupName);
        recipeGroup.addRecipeKey(this.getRecipeKey(recipe));
        this.recipeRegisterMap.getOrDefault((Object)recipeType, recipe1 -> {
            throw new UnsupportedVersionException("Can not register " + recipeType.name().toLowerCase() + " recipe");
        }).accept(recipe);
    }

    public Map<RecipeType, Map<String, RecipeGroup>> recipeMap() {
        return this.pluginRecipeMap;
    }

    public Recipe getRecipe(NamespacedKey namespacedKey) {
        if (this.supportPotionMix.booleanValue() && this.potionMixRecipeMap.containsKey(namespacedKey)) {
            return this.potionMixRecipeMap.get(namespacedKey);
        }
        if (this.anvilRecipeMap.containsKey(namespacedKey)) {
            return this.anvilRecipeMap.get(namespacedKey);
        }
        return Bukkit.getRecipe((NamespacedKey)namespacedKey);
    }

    @Nullable
    public NamespacedKey getRecipeKey(Recipe recipe) {
        if (recipe instanceof CustomRecipe) {
            CustomRecipe customRecipe = (CustomRecipe)recipe;
            return customRecipe.key();
        }
        if (recipe instanceof Keyed) {
            Keyed keyed = (Keyed)recipe;
            return keyed.getKey();
        }
        return null;
    }

    private void reloadRemovedRecipes() {
        this.removedRecipesConfigWrapper.reloadConfig();
        List removedRecipes = ((YamlConfiguration)this.removedRecipesConfigWrapper.config()).getStringList("recipes");
        if (((Boolean)PluginConfigs.REMOVE_ALL_VANILLA_RECIPE.value()).booleanValue()) {
            this.serverRecipesCache.forEach((key, recipe) -> {
                if (key.getNamespace().equals("minecraft")) {
                    if (removedRecipes.contains(key.toString())) {
                        return;
                    }
                    removedRecipes.add(key.toString());
                }
            });
        }
        ArrayList<NamespacedKey> removedRecipeKeys = new ArrayList<NamespacedKey>();
        for (String recipeKey : removedRecipes) {
            removedRecipeKeys.add(NamespacedKey.fromString((String)recipeKey));
        }
        this.disableOtherPluginsRecipe(removedRecipeKeys, false);
    }

    public boolean disableOtherPluginsRecipe(List<NamespacedKey> recipeKeys, boolean save) {
        if (save) {
            this.addKeyToRemovedConfig(recipeKeys);
        }
        this.addRecipeToRemovedRecipeRecycleBin(recipeKeys);
        return this.removeRecipes(recipeKeys) > 0;
    }

    public boolean removeCraftorithmRecipe(String recipeGroupName, boolean deleteFile) {
        for (Map.Entry<RecipeType, Map<String, RecipeGroup>> recipeTypeMapEntry : this.pluginRecipeMap.entrySet()) {
            RecipeType recipeType = recipeTypeMapEntry.getKey();
            Map<String, RecipeGroup> recipeGroupMap = recipeTypeMapEntry.getValue();
            if (!recipeGroupMap.containsKey(recipeGroupName)) continue;
            RecipeGroup recipeGroup = recipeGroupMap.get(recipeGroupName);
            if (recipeGroup == null) {
                return false;
            }
            this.recipeRemoverMap.get((Object)recipeType).accept(recipeGroup.groupRecipeKeys());
            BukkitConfigWrapper recipeConfig = recipeGroupMap.get(recipeGroupName).recipeGroupConfig();
            if (deleteFile) {
                recipeConfig.configFile().delete();
            }
            recipeGroupMap.remove(recipeGroupName);
            return true;
        }
        return false;
    }

    private void addKeyToRemovedConfig(List<NamespacedKey> keys) {
        List removedList = ((YamlConfiguration)this.removedRecipesConfigWrapper.config()).getStringList("recipes");
        for (NamespacedKey key : keys) {
            String keyStr;
            if (key.getNamespace().equals("minecraft") && ((Boolean)PluginConfigs.REMOVE_ALL_VANILLA_RECIPE.value()).booleanValue() || removedList.contains(keyStr = key.toString())) continue;
            removedList.add(keyStr);
        }
        this.removedRecipesConfigWrapper.set("recipes", removedList);
        this.removedRecipesConfigWrapper.saveConfig();
    }

    private void addRecipeToRemovedRecipeRecycleBin(List<NamespacedKey> recipeKeys) {
        for (NamespacedKey recipeKey : recipeKeys) {
            Recipe recipe = this.getRecipe(recipeKey);
            if (recipe == null) continue;
            this.removeRecipeRecycleBin.add(recipe);
        }
    }

    private int removeRecipes(List<NamespacedKey> recipeKeys) {
        if (recipeKeys == null || recipeKeys.isEmpty()) {
            return 0;
        }
        for (NamespacedKey recipeKey : recipeKeys) {
            this.recipeUnlockMap.remove(recipeKey);
        }
        int removedRecipeNum = 0;
        for (NamespacedKey recipeKey : recipeKeys) {
            if (!Bukkit.removeRecipe((NamespacedKey)recipeKey)) continue;
            ++removedRecipeNum;
        }
        for (NamespacedKey recipeKey : recipeKeys) {
            this.serverRecipesCache.remove(recipeKey);
        }
        return removedRecipeNum;
    }

    public boolean hasCraftorithmRecipe(String recipeName) {
        return this.getRecipeGroups().contains(recipeName);
    }

    @Nullable
    public RecipeGroup getRecipeGroup(String groupName) {
        for (Map.Entry<RecipeType, Map<String, RecipeGroup>> recipeTypeMapEntry : this.pluginRecipeMap.entrySet()) {
            Map<String, RecipeGroup> recipeGroupMap = recipeTypeMapEntry.getValue();
            if (!recipeGroupMap.containsKey(groupName)) continue;
            return recipeGroupMap.get(groupName);
        }
        return null;
    }

    public YamlConfiguration getRecipeConfig(NamespacedKey recipeKey) {
        if (!recipeKey.getNamespace().equals("craftorithm")) {
            return null;
        }
        for (Map.Entry<RecipeType, Map<String, RecipeGroup>> recipeTypeMapEntry : this.pluginRecipeMap.entrySet()) {
            Map<String, RecipeGroup> recipeGroupMap = recipeTypeMapEntry.getValue();
            for (String recipeGroupName : recipeGroupMap.keySet()) {
                RecipeGroup recipeGroup = recipeGroupMap.get(recipeGroupName);
                if (!recipeGroup.contains(recipeKey)) continue;
                BukkitConfigWrapper configWrapper = recipeGroup.recipeGroupConfig();
                return configWrapper == null ? null : (YamlConfiguration)configWrapper.config();
            }
        }
        return null;
    }

    public int getRecipeGroupSortId(String recipeGroupName) {
        for (Map.Entry<RecipeType, Map<String, RecipeGroup>> pluginRecipeMapEntry : this.pluginRecipeMap.entrySet()) {
            Map<String, RecipeGroup> recipeGroupMap = pluginRecipeMapEntry.getValue();
            if (!recipeGroupMap.containsKey(recipeGroupName)) continue;
            return recipeGroupMap.get(recipeGroupName).sortId();
        }
        return 0;
    }

    @Nullable
    public AnvilRecipe matchAnvilRecipe(ItemStack base, ItemStack addition) {
        String baseId = ItemManager.INSTANCE.matchItemName(base, true);
        baseId = baseId != null ? baseId : base.getType().getKey().toString();
        String additionId = ItemManager.INSTANCE.matchItemName(addition, true);
        additionId = additionId != null ? additionId : addition.getType().getKey().toString();
        BukkitMsgSender.INSTANCE.debug("base: " + baseId + ", addition: " + additionId);
        for (Map.Entry<NamespacedKey, AnvilRecipe> anvilRecipeEntry : this.anvilRecipeMap.entrySet()) {
            AnvilRecipe anvilRecipe = anvilRecipeEntry.getValue();
            String recipeBaseId = ItemManager.INSTANCE.matchItemName(anvilRecipe.base(), true);
            recipeBaseId = recipeBaseId != null ? recipeBaseId : anvilRecipe.base().getType().getKey().toString();
            String recipeAdditionId = ItemManager.INSTANCE.matchItemName(anvilRecipe.addition(), true);
            recipeAdditionId = recipeAdditionId != null ? recipeAdditionId : anvilRecipe.addition().getType().getKey().toString();
            BukkitMsgSender.INSTANCE.debug("recipe base: " + recipeBaseId + ", recipe addition: " + recipeAdditionId);
            if (!Objects.equals(baseId, recipeBaseId)) continue;
            BukkitMsgSender.INSTANCE.debug("matched base id");
            if (base.getAmount() < anvilRecipe.base().getAmount()) continue;
            BukkitMsgSender.INSTANCE.debug("matched base amount");
            if (!Objects.equals(additionId, recipeAdditionId)) continue;
            BukkitMsgSender.INSTANCE.debug("matched addition id");
            if (addition.getAmount() < anvilRecipe.addition().getAmount()) continue;
            BukkitMsgSender.INSTANCE.debug("matched addition amount");
            return anvilRecipe;
        }
        return null;
    }

    public RecipeType getRecipeType(Recipe recipe) {
        Recipe recipe2 = recipe;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedRecipe.class, ShapelessRecipe.class, CookingRecipe.class, SmithingRecipe.class, PotionMixRecipe.class, StonecuttingRecipe.class, AnvilRecipe.class}, (Object)recipe2, n)) {
            case 0 -> {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
                yield RecipeType.SHAPED;
            }
            case 1 -> {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe2;
                yield RecipeType.SHAPELESS;
            }
            case 2 -> {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe2;
                yield RecipeType.COOKING;
            }
            case 3 -> {
                SmithingRecipe smithingRecipe = (SmithingRecipe)recipe2;
                yield RecipeType.SMITHING;
            }
            case 4 -> {
                PotionMixRecipe potionMixRecipe = (PotionMixRecipe)recipe2;
                yield RecipeType.POTION;
            }
            case 5 -> {
                StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe2;
                yield RecipeType.STONE_CUTTING;
            }
            case 6 -> {
                AnvilRecipe anvilRecipe = (AnvilRecipe)recipe2;
                yield RecipeType.ANVIL;
            }
            default -> RecipeType.UNKNOWN;
        };
    }

    public StringLangEntry getRecipeTypeName(RecipeType recipeType) {
        return switch (recipeType) {
            case RecipeType.SHAPED -> Languages.RECIPE_TYPE_NAME_SHAPED;
            case RecipeType.SHAPELESS -> Languages.RECIPE_TYPE_NAME_SHAPELESS;
            case RecipeType.COOKING -> Languages.RECIPE_TYPE_NAME_COOKING;
            case RecipeType.SMITHING -> Languages.RECIPE_TYPE_NAME_SMITHING;
            case RecipeType.STONE_CUTTING -> Languages.RECIPE_TYPE_NAME_STONE_CUTTING;
            case RecipeType.POTION -> Languages.RECIPE_TYPE_NAME_POTION;
            case RecipeType.ANVIL -> Languages.RECIPE_TYPE_NAME_ANVIL;
            default -> null;
        };
    }

    public boolean getSmithingCopyEnchantment(Recipe recipe) {
        if (!(recipe instanceof SmithingRecipe)) {
            return false;
        }
        NamespacedKey namespacedKey = this.getRecipeKey(recipe);
        if (namespacedKey == null) {
            return false;
        }
        RecipeRegistry recipeRegistry = this.recipeRegistryMap.get(namespacedKey);
        if (!(recipeRegistry instanceof SmithingRecipeRegistry)) {
            return false;
        }
        SmithingRecipeRegistry smithingRecipeRegistry = (SmithingRecipeRegistry)recipeRegistry;
        return smithingRecipeRegistry.copyEnchantments();
    }

    public void resetRecipes() {
        this.pluginRecipeMap.forEach((type, recipeGroupMaps) -> recipeGroupMaps.forEach((group, recipeKeys) -> this.removeCraftorithmRecipe((String)group, false)));
        this.potionMixRecipeMap.clear();
        this.anvilRecipeMap.clear();
        for (Recipe recipe : this.removeRecipeRecycleBin) {
            RecipeUtils.addBukkitRecipe(recipe);
        }
        this.removeRecipeRecycleBin.clear();
        this.pluginRecipeMap.clear();
        this.recipeUnlockMap.clear();
    }

    public void loadServerRecipeCache() {
        Iterator recipeIterator = Bukkit.recipeIterator();
        this.serverRecipesCache.clear();
        while (recipeIterator.hasNext()) {
            Recipe recipe = (Recipe)recipeIterator.next();
            NamespacedKey key = this.getRecipeKey(recipe);
            if (key == null) continue;
            this.serverRecipesCache.put(key, recipe);
        }
    }

    public Map<NamespacedKey, PotionMixRecipe> potionMixRecipeMap() {
        return this.potionMixRecipeMap;
    }

    public List<String> getRecipeGroups() {
        ArrayList<String> recipes = new ArrayList<String>();
        for (Map<String, RecipeGroup> value : this.pluginRecipeMap.values()) {
            recipes.addAll(value.keySet());
        }
        return recipes;
    }

    public Map<NamespacedKey, Boolean> recipeUnlockMap() {
        return this.recipeUnlockMap;
    }

    public Map<NamespacedKey, Recipe> serverRecipesCache() {
        return this.serverRecipesCache;
    }

    public boolean supportPotionMix() {
        if (this.supportPotionMix == null) {
            this.supportPotionMix = CrypticLibBukkit.isPaper();
        }
        return this.supportPotionMix;
    }

    private void saveDefConfigFile(List<File> allFiles) {
        if (!((Boolean)PluginConfigs.RELEASE_DEFAULT_RECIPES.value()).booleanValue()) {
            return;
        }
        Craftorithm.instance().saveResource("recipes/example_shaped.yml", false);
        Craftorithm.instance().saveResource("recipes/example_shapeless.yml", false);
        allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_shaped.yml"));
        allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_shapeless.yml"));
        Craftorithm.instance().saveResource("recipes/example_smithing.yml", false);
        Craftorithm.instance().saveResource("recipes/example_stone_cutting.yml", false);
        Craftorithm.instance().saveResource("recipes/example_cooking.yml", false);
        allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_cooking.yml"));
        allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_smithing.yml"));
        allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_stone_cutting.yml"));
        Craftorithm.instance().saveResource("recipes/example_random_cooking.yml", false);
        allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_random_cooking.yml"));
        if (this.supportPotionMix()) {
            Craftorithm.instance().saveResource("recipes/example_potion.yml", false);
            allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_potion.yml"));
        }
        if (((Boolean)PluginConfigs.ENABLE_ANVIL_RECIPE.value()).booleanValue()) {
            Craftorithm.instance().saveResource("recipes/example_anvil.yml", false);
            allFiles.add(new File(this.RECIPE_FILE_FOLDER, "example_anvil.yml"));
        }
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        if (lifeCycle.equals((Object)LifeCycle.ENABLE)) {
            this.recipeRegisterMap.put(RecipeType.SHAPED, RecipeUtils::addBukkitRecipe);
            this.recipeRemoverMap.put(RecipeType.SHAPED, this::removeRecipes);
            this.recipeRegisterMap.put(RecipeType.SHAPELESS, RecipeUtils::addBukkitRecipe);
            this.recipeRemoverMap.put(RecipeType.SHAPELESS, this::removeRecipes);
            this.recipeRegisterMap.put(RecipeType.COOKING, RecipeUtils::addBukkitRecipe);
            this.recipeRemoverMap.put(RecipeType.COOKING, this::removeRecipes);
            this.recipeRegisterMap.put(RecipeType.STONE_CUTTING, RecipeUtils::addBukkitRecipe);
            this.recipeRemoverMap.put(RecipeType.STONE_CUTTING, this::removeRecipes);
            this.recipeRegisterMap.put(RecipeType.SMITHING, RecipeUtils::addBukkitRecipe);
            this.recipeRemoverMap.put(RecipeType.SMITHING, this::removeRecipes);
            this.recipeRegisterMap.put(RecipeType.RANDOM_COOKING, RecipeUtils::addBukkitRecipe);
            this.recipeRemoverMap.put(RecipeType.RANDOM_COOKING, this::removeRecipes);
            if (((Boolean)PluginConfigs.ENABLE_ANVIL_RECIPE.value()).booleanValue()) {
                this.recipeRegisterMap.put(RecipeType.ANVIL, recipe -> this.anvilRecipeMap.put(this.getRecipeKey((Recipe)recipe), (AnvilRecipe)recipe));
                this.recipeRemoverMap.put(RecipeType.ANVIL, keys -> {
                    for (NamespacedKey key : keys) {
                        this.anvilRecipeMap.remove(key);
                    }
                });
            }
            if (this.supportPotionMix()) {
                this.recipeRegisterMap.put(RecipeType.POTION, recipe -> {
                    Bukkit.getPotionBrewer().addPotionMix(((PotionMixRecipe)recipe).potionMix());
                    this.potionMixRecipeMap.put(((PotionMixRecipe)recipe).key(), (PotionMixRecipe)recipe);
                });
                this.recipeRemoverMap.put(RecipeType.POTION, recipeList -> {
                    for (NamespacedKey recipeKey : recipeList) {
                        Bukkit.getPotionBrewer().removePotionMix(recipeKey);
                    }
                });
            }
        } else {
            this.reloadRecipeManager();
        }
    }

    static {
        UNLOCKABLE_RECIPE_TYPE = List.of(RecipeType.SHAPED, RecipeType.SHAPELESS, RecipeType.COOKING, RecipeType.SMITHING, RecipeType.STONE_CUTTING, RecipeType.RANDOM_COOKING);
    }
}

