/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe.registry.impl;

import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.custom.AnvilRecipe;
import com.github.yufiriamazenta.craftorithm.recipe.registry.RecipeRegistry;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeRegistry
extends RecipeRegistry {
    private ItemStack base;
    private ItemStack addition;
    private boolean copyNbt = true;
    private int costLevel = 0;
    private boolean copyEnchantments = true;

    public AnvilRecipeRegistry(@Nullable String group, @NotNull NamespacedKey namespacedKey, @NotNull ItemStack result) {
        super(group, namespacedKey, result);
    }

    @Override
    public void register() {
        Preconditions.checkArgument((!ItemHelper.isAir(this.base) ? 1 : 0) != 0, (Object)"Recipe base cannot be null");
        Preconditions.checkArgument((!ItemHelper.isAir(this.addition) ? 1 : 0) != 0, (Object)"Recipe base cannot be null");
        Preconditions.checkArgument((!ItemHelper.isAir(this.result()) ? 1 : 0) != 0, (Object)"Recipe base cannot be null");
        Objects.requireNonNull(this.namespacedKey(), "Recipe key cannot be null");
        AnvilRecipe anvilRecipe = new AnvilRecipe(this.namespacedKey(), this.result(), this.base, this.addition);
        anvilRecipe.setCopyNbt(this.copyNbt);
        anvilRecipe.setCostLevel(this.costLevel);
        anvilRecipe.setCopyEnchantments(this.copyEnchantments);
        RecipeManager.INSTANCE.regRecipe(this.group(), anvilRecipe, RecipeType.ANVIL);
    }

    public ItemStack base() {
        return this.base;
    }

    public AnvilRecipeRegistry setBase(ItemStack base) {
        this.base = base;
        return this;
    }

    public ItemStack addition() {
        return this.addition;
    }

    public AnvilRecipeRegistry setAddition(ItemStack addition) {
        this.addition = addition;
        return this;
    }

    public boolean copyNbt() {
        return this.copyNbt;
    }

    public AnvilRecipeRegistry setCopyNbt(boolean copyNbt) {
        this.copyNbt = copyNbt;
        return this;
    }

    public int costLevel() {
        return this.costLevel;
    }

    public AnvilRecipeRegistry setCostLevel(int costLevel) {
        this.costLevel = costLevel;
        return this;
    }

    public boolean copyEnchantments() {
        return this.copyEnchantments;
    }

    public AnvilRecipeRegistry setCopyEnchantments(boolean copyEnchantments) {
        this.copyEnchantments = copyEnchantments;
        return this;
    }
}

