/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe.registry.impl;

import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.registry.RecipeRegistry;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingRecipeRegistry
extends RecipeRegistry {
    private RecipeChoice source;
    private int time = 200;
    private float exp = 0.0f;
    private CookingBlock cookingBlock;
    @Nullable
    private CookingBookCategory cookingBookCategory;

    public CookingRecipeRegistry(@NotNull String group, @NotNull NamespacedKey namespacedKey, @NotNull ItemStack result) {
        super(group, namespacedKey, result);
    }

    @Override
    public void register() {
        Objects.requireNonNull(this.namespacedKey(), "Recipe key cannot be null");
        Objects.requireNonNull(this.result(), "Recipe key cannot be null");
        Objects.requireNonNull(this.source, "Recipe ingredient cannot be null");
        FurnaceRecipe cookingRecipe = switch (this.cookingBlock.ordinal()) {
            default -> new FurnaceRecipe(this.namespacedKey(), this.result(), this.source, this.exp, this.time);
            case 2 -> new SmokingRecipe(this.namespacedKey(), this.result(), this.source, this.exp, this.time);
            case 1 -> new BlastingRecipe(this.namespacedKey(), this.result(), this.source, this.exp, this.time);
            case 3 -> new CampfireRecipe(this.namespacedKey(), this.result(), this.source, this.exp, this.time);
        };
        cookingRecipe.setGroup(this.group());
        if (this.cookingBookCategory != null) {
            cookingRecipe.setCategory(this.cookingBookCategory);
        }
        RecipeManager.INSTANCE.regRecipe(this.group(), (Recipe)cookingRecipe, RecipeType.COOKING);
    }

    public RecipeChoice source() {
        return this.source;
    }

    public CookingRecipeRegistry setSource(RecipeChoice source) {
        this.source = source;
        return this;
    }

    public int time() {
        return this.time;
    }

    public CookingRecipeRegistry setTime(int time) {
        this.time = time;
        return this;
    }

    public float exp() {
        return this.exp;
    }

    public CookingRecipeRegistry setExp(float exp) {
        this.exp = exp;
        return this;
    }

    public CookingBlock cookingBlock() {
        return this.cookingBlock;
    }

    public CookingRecipeRegistry setCookingBlock(String cookingBlock) {
        this.cookingBlock = CookingBlock.valueOf(cookingBlock.toUpperCase());
        return this;
    }

    public CookingRecipeRegistry setCookingBlock(CookingBlock cookingBlock) {
        this.cookingBlock = cookingBlock;
        return this;
    }

    @Nullable
    public CookingBookCategory getCookingBookCategory() {
        return this.cookingBookCategory;
    }

    public CookingRecipeRegistry setCookingBookCategory(CookingBookCategory cookingBookCategory) {
        this.cookingBookCategory = cookingBookCategory;
        return this;
    }

    public static enum CookingBlock {
        FURNACE(Material.FURNACE),
        BLAST_FURNACE(Material.BLAST_FURNACE),
        SMOKER(Material.SMOKER),
        CAMPFIRE(Material.CAMPFIRE);

        private final Material blockMaterial;

        private CookingBlock(Material blockMaterial) {
            this.blockMaterial = blockMaterial;
        }

        public Material blockMaterial() {
            return this.blockMaterial;
        }
    }
}

