/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe.registry.impl;

import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.CookingRecipeRegistry;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmokingRecipe;
import org.jetbrains.annotations.NotNull;

public class RandomCookingRecipeRegistry
extends CookingRecipeRegistry {
    public RandomCookingRecipeRegistry(@NotNull String group, @NotNull NamespacedKey namespacedKey, @NotNull ItemStack result) {
        super(group, namespacedKey, result);
    }

    @Override
    public void register() {
        Objects.requireNonNull(this.namespacedKey(), "Recipe key cannot be null");
        Objects.requireNonNull(this.result(), "Recipe key cannot be null");
        Objects.requireNonNull(this.source(), "Recipe ingredient cannot be null");
        FurnaceRecipe cookingRecipe = switch (this.cookingBlock()) {
            default -> new FurnaceRecipe(this.namespacedKey(), this.result(), this.source(), this.exp(), this.time());
            case CookingRecipeRegistry.CookingBlock.SMOKER -> new SmokingRecipe(this.namespacedKey(), this.result(), this.source(), this.exp(), this.time());
            case CookingRecipeRegistry.CookingBlock.BLAST_FURNACE -> new BlastingRecipe(this.namespacedKey(), this.result(), this.source(), this.exp(), this.time());
            case CookingRecipeRegistry.CookingBlock.CAMPFIRE -> new CampfireRecipe(this.namespacedKey(), this.result(), this.source(), this.exp(), this.time());
        };
        cookingRecipe.setGroup(this.group());
        RecipeManager.INSTANCE.regRecipe(this.group(), (Recipe)cookingRecipe, RecipeType.RANDOM_COOKING);
    }
}

