/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe.registry.impl;

import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.CraftingRecipeRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.jetbrains.annotations.NotNull;

public final class ShapedRecipeRegistry
extends CraftingRecipeRegistry {
    private String[] shape;
    private Map<Character, RecipeChoice> recipeChoiceMap;

    public ShapedRecipeRegistry(@NotNull String group, @NotNull NamespacedKey namespacedKey, @NotNull ItemStack result) {
        super(group, namespacedKey, result);
    }

    public String[] shape() {
        return this.shape;
    }

    public ShapedRecipeRegistry setShape(String[] shape) {
        this.shape = shape;
        return this;
    }

    public Map<Character, RecipeChoice> recipeChoiceMap() {
        return this.recipeChoiceMap;
    }

    public ShapedRecipeRegistry setRecipeChoiceMap(Map<Character, RecipeChoice> recipeChoiceMap) {
        this.recipeChoiceMap = recipeChoiceMap;
        return this;
    }

    @Override
    public ShapedRecipeRegistry setCraftingBookCategory(CraftingBookCategory craftingBookCategory) {
        return (ShapedRecipeRegistry)super.setCraftingBookCategory(craftingBookCategory);
    }

    @Override
    public void register() {
        Objects.requireNonNull(this.namespacedKey(), "Recipe key cannot be null");
        Objects.requireNonNull(this.result(), "Recipe key cannot be null");
        Objects.requireNonNull(this.shape, "Recipe shape cannot be null");
        Objects.requireNonNull(this.recipeChoiceMap, "Recipe ingredients cannot be null");
        ShapedRecipe shapedRecipe = new ShapedRecipe(this.namespacedKey(), this.result());
        shapedRecipe.shape(this.shape);
        HashSet<Character> shapeStrChars = new HashSet<Character>();
        for (String s : this.shape) {
            for (char c : s.toCharArray()) {
                shapeStrChars.add(Character.valueOf(c));
            }
        }
        HashSet<Character> keySet = new HashSet<Character>(this.recipeChoiceMap.keySet());
        keySet.removeIf(character -> !shapeStrChars.contains(character));
        for (Character ingredientKey : keySet) {
            shapedRecipe.setIngredient(ingredientKey.charValue(), this.recipeChoiceMap.get(ingredientKey));
        }
        if (this.craftingBookCategory != null) {
            shapedRecipe.setCategory(this.craftingBookCategory);
        }
        shapedRecipe.setGroup(this.group());
        RecipeManager.INSTANCE.regRecipe(this.group(), (Recipe)shapedRecipe, RecipeType.SHAPED);
    }
}

